/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.protocol.saml.mappers.AbstractSAMLProtocolMapper;
import org.keycloak.provider.ProviderConfigProperty;

public class HardcodedRole
extends AbstractSAMLProtocolMapper {
    public static final String PROVIDER_ID = "saml-hardcode-role-mapper";
    public static final String ATTRIBUTE_VALUE = "attribute.value";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Hardcoded role";
    }

    public String getDisplayCategory() {
        return "AttributeStatement Mapper";
    }

    public String getHelpText() {
        return "Hardcode role into SAML Assertion.";
    }

    public static ProtocolMapperModel create(String name, String role) {
        String mapperId = PROVIDER_ID;
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(mapperId);
        mapper.setProtocol("saml");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("role", role);
        mapper.setConfig(config);
        return mapper;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("role");
        property.setLabel("Role");
        property.setHelpText("Arbitrary role name you want to hardcode.  This role does not have to exist in current realm and can be just any string you need");
        property.setType("Role");
        configProperties.add(property);
    }
}

