/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.operations.QueryOperation;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.remote.client.QueryResponse;

public final class RemoteQuery
extends BaseQuery {
    private static final Log log = LogFactory.getLog(RemoteQuery.class, Log.class);
    private final RemoteCacheImpl cache;
    private final SerializationContext serializationContext;
    private List results = null;
    private int totalResults;

    RemoteQuery(QueryFactory queryFactory, RemoteCacheImpl cache, SerializationContext serializationContext, String jpaQuery, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults) {
        super(queryFactory, jpaQuery, namedParameters, projection, startOffset, maxResults);
        this.cache = cache;
        this.serializationContext = serializationContext;
    }

    public void resetQuery() {
        this.results = null;
    }

    public <T> List<T> list() {
        if (this.results == null) {
            this.results = this.executeQuery();
        }
        return this.results;
    }

    private List<Object> executeQuery() {
        this.checkParameters();
        QueryOperation op = this.cache.getOperationsFactory().newQueryOperation(this);
        QueryResponse response = (QueryResponse)op.execute();
        this.totalResults = (int)response.getTotalResults();
        return this.unwrapResults(response.getProjectionSize(), response.getResults());
    }

    private List<Object> unwrapResults(int projectionSize, List<WrappedMessage> results) {
        ArrayList<Object> unwrappedResults;
        if (projectionSize > 0) {
            unwrappedResults = new ArrayList(results.size() / projectionSize);
            Iterator<WrappedMessage> it = results.iterator();
            while (it.hasNext()) {
                Object[] row = new Object[projectionSize];
                for (int i = 0; i < row.length; ++i) {
                    row[i] = it.next().getValue();
                }
                unwrappedResults.add(row);
            }
        } else {
            unwrappedResults = new ArrayList<Object>(results.size());
            for (WrappedMessage r : results) {
                try {
                    byte[] bytes = (byte[])r.getValue();
                    Object o = ProtobufUtil.fromWrappedByteArray((SerializationContext)this.serializationContext, (byte[])bytes);
                    unwrappedResults.add(o);
                }
                catch (IOException e) {
                    throw new HotRodClientException(e);
                }
            }
        }
        return unwrappedResults;
    }

    private void checkParameters() {
        if (this.namedParameters != null) {
            for (Map.Entry e : this.namedParameters.entrySet()) {
                if (e.getValue() != null) continue;
                throw log.queryParameterNotSet((String)e.getKey());
            }
        }
    }

    public int getResultSize() {
        this.list();
        return this.totalResults;
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public String toString() {
        return "RemoteQuery{jpaQuery=" + this.jpaQuery + ", namedParameters=" + this.namedParameters + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + '}';
    }
}

