/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.Requirement;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.capability.RuntimeCapability;

public class CapabilityReference
implements CapabilityReferenceRecorder {
    private final Requirement requirement;
    private final Capability capability;

    public CapabilityReference(Requirement requirement, Capability capability) {
        this.requirement = requirement;
        this.capability = capability;
    }

    public void addCapabilityRequirements(OperationContext context, String attributeName, String ... attributeValues) {
        String dependentName = this.capability.getRuntimeCapability(context.getCurrentAddress()).getName();
        for (String attributeValue : attributeValues) {
            String requirementName = RuntimeCapability.buildDynamicCapabilityName((String)this.requirement.getName(), (String)attributeValue);
            context.registerAdditionalCapabilityRequirement(requirementName, dependentName, attributeName);
        }
    }

    public void removeCapabilityRequirements(OperationContext context, String attributeName, String ... attributeValues) {
        String dependentName = this.capability.getRuntimeCapability(context.getCurrentAddress()).getName();
        for (String attributeValue : attributeValues) {
            String requirementName = RuntimeCapability.buildDynamicCapabilityName((String)this.requirement.getName(), (String)attributeValue);
            context.deregisterCapabilityRequirement(requirementName, dependentName);
        }
    }

    public String getBaseDependentName() {
        return ((RuntimeCapability)this.capability.getDefinition()).getName();
    }

    public String getBaseRequirementName() {
        return this.requirement.getName();
    }

    public boolean isDynamicDependent() {
        return true;
    }
}

