/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.messaging.activemq.BridgeAdd;
import org.wildfly.extension.messaging.activemq.MessagingServices;

public class BridgeRemove
extends AbstractRemoveStepHandler {
    public static final BridgeRemove INSTANCE = new BridgeRemove();

    private BridgeRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName serviceName;
        String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController service = registry.getService(serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (service != null && service.getState() == ServiceController.State.UP) {
            ActiveMQServer server = (ActiveMQServer)ActiveMQServer.class.cast(service.getValue());
            try {
                server.getActiveMQServerControl().destroyBridge(name);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName serviceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController service = registry.getService(serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (service != null && service.getState() == ServiceController.State.UP) {
            String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            BridgeConfiguration bridgeConfiguration = BridgeAdd.createBridgeConfiguration(context, name, model);
            ActiveMQServer server = (ActiveMQServer)ActiveMQServer.class.cast(service.getValue());
            BridgeAdd.createBridge(name, bridgeConfiguration, (ActiveMQServerControl)server.getActiveMQServerControl());
        }
    }
}

