/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.Chronology;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactBuilderFactory;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactBuilderFactory;

public class SAMLConfiguration {
    private static String defaultDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private DateTimeFormatter dateFormatter;
    private SAML1ArtifactBuilderFactory saml1ArtifactBuilderFactory;
    private SAML2ArtifactBuilderFactory saml2ArtifactBuilderFactory;
    private List<String> allowedBindingURLSchemes;

    public SAMLConfiguration() {
        ArrayList<String> schemes = new ArrayList<String>();
        schemes.add("http");
        schemes.add("https");
        this.setAllowedBindingURLSchemes(schemes);
    }

    public DateTimeFormatter getSAMLDateFormatter() {
        if (this.dateFormatter == null) {
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)defaultDateFormat);
            this.dateFormatter = formatter.withChronology((Chronology)ISOChronology.getInstanceUTC());
        }
        return this.dateFormatter;
    }

    public void setSAMLDateFormat(String format) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
        this.dateFormatter = formatter.withChronology((Chronology)ISOChronology.getInstanceUTC());
    }

    public SAML1ArtifactBuilderFactory getSAML1ArtifactBuilderFactory() {
        return this.saml1ArtifactBuilderFactory;
    }

    public void setSAML1ArtifactBuilderFactory(SAML1ArtifactBuilderFactory factory) {
        this.saml1ArtifactBuilderFactory = factory;
    }

    public SAML2ArtifactBuilderFactory getSAML2ArtifactBuilderFactory() {
        return this.saml2ArtifactBuilderFactory;
    }

    public void setSAML2ArtifactBuilderFactory(SAML2ArtifactBuilderFactory factory) {
        this.saml2ArtifactBuilderFactory = factory;
    }

    public List<String> getAllowedBindingURLSchemes() {
        return Collections.unmodifiableList(this.allowedBindingURLSchemes);
    }

    public void setAllowedBindingURLSchemes(List<String> schemes) {
        this.allowedBindingURLSchemes = schemes == null || schemes.isEmpty() ? Collections.emptyList() : new ArrayList<String>(schemes);
    }
}

