/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc.model.nav;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.xml.bind.v2.model.nav.Navigator;
import com.sun.xml.bind.v2.runtime.Location;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

public final class ApNavigator
implements Navigator<TypeMirror, TypeElement, VariableElement, ExecutableElement> {
    private final ProcessingEnvironment env;
    private final PrimitiveType primitiveByte;
    private static final Map<Class, TypeKind> primitives = new HashMap<Class, TypeKind>();
    private static final TypeMirror DUMMY;
    private final SimpleTypeVisitor6<TypeMirror, TypeElement> baseClassFinder = new SimpleTypeVisitor6<TypeMirror, TypeElement>(){

        @Override
        public TypeMirror visitDeclared(DeclaredType t, TypeElement sup) {
            TypeMirror typeMirror;
            if (t.asElement().equals(sup)) {
                return t;
            }
            for (TypeMirror typeMirror2 : ApNavigator.this.env.getTypeUtils().directSupertypes(t)) {
                TypeMirror r2 = this.visitDeclared((DeclaredType)typeMirror2, sup);
                if (r2 == null) continue;
                return r2;
            }
            TypeMirror superclass = ((TypeElement)t.asElement()).getSuperclass();
            if (!superclass.getKind().equals((Object)TypeKind.NONE) && (typeMirror = this.visitDeclared((DeclaredType)superclass, sup)) != null) {
                return typeMirror;
            }
            return null;
        }

        @Override
        public TypeMirror visitTypeVariable(TypeVariable t, TypeElement typeElement) {
            for (TypeMirror typeMirror : ((TypeParameterElement)t.asElement()).getBounds()) {
                TypeMirror m = (TypeMirror)this.visit(typeMirror, typeElement);
                if (m == null) continue;
                return m;
            }
            return null;
        }

        @Override
        public TypeMirror visitArray(ArrayType t, TypeElement typeElement) {
            return null;
        }

        @Override
        public TypeMirror visitWildcard(WildcardType t, TypeElement typeElement) {
            return (TypeMirror)this.visit(t.getExtendsBound(), typeElement);
        }

        @Override
        protected TypeMirror defaultAction(TypeMirror e, TypeElement typeElement) {
            return e;
        }
    };

    public ApNavigator(ProcessingEnvironment env) {
        this.env = env;
        this.primitiveByte = env.getTypeUtils().getPrimitiveType(TypeKind.BYTE);
    }

    public TypeElement getSuperClass(TypeElement typeElement) {
        if (typeElement.getKind().equals((Object)ElementKind.CLASS)) {
            TypeMirror sup = typeElement.getSuperclass();
            if (!sup.getKind().equals((Object)TypeKind.NONE)) {
                return (TypeElement)((DeclaredType)sup).asElement();
            }
            return null;
        }
        return this.env.getElementUtils().getTypeElement(Object.class.getName());
    }

    public TypeMirror getBaseClass(TypeMirror type, TypeElement sup) {
        return (TypeMirror)this.baseClassFinder.visit(type, sup);
    }

    public String getClassName(TypeElement t) {
        return t.getQualifiedName().toString();
    }

    public String getTypeName(TypeMirror typeMirror) {
        return typeMirror.toString();
    }

    public String getClassShortName(TypeElement t) {
        return t.getSimpleName().toString();
    }

    public Collection<VariableElement> getDeclaredFields(TypeElement typeElement) {
        return ElementFilter.fieldsIn(typeElement.getEnclosedElements());
    }

    public VariableElement getDeclaredField(TypeElement clazz, String fieldName) {
        for (VariableElement fd : ElementFilter.fieldsIn(clazz.getEnclosedElements())) {
            if (!fd.getSimpleName().toString().equals(fieldName)) continue;
            return fd;
        }
        return null;
    }

    public Collection<ExecutableElement> getDeclaredMethods(TypeElement typeElement) {
        return ElementFilter.methodsIn(typeElement.getEnclosedElements());
    }

    public TypeElement getDeclaringClassForField(VariableElement f) {
        return (TypeElement)f.getEnclosingElement();
    }

    public TypeElement getDeclaringClassForMethod(ExecutableElement m) {
        return (TypeElement)m.getEnclosingElement();
    }

    public TypeMirror getFieldType(VariableElement f) {
        return f.asType();
    }

    public String getFieldName(VariableElement f) {
        return f.getSimpleName().toString();
    }

    public String getMethodName(ExecutableElement m) {
        return m.getSimpleName().toString();
    }

    public TypeMirror getReturnType(ExecutableElement m) {
        return m.getReturnType();
    }

    public TypeMirror[] getMethodParameters(ExecutableElement m) {
        List<? extends VariableElement> ps = m.getParameters();
        TypeMirror[] r = new TypeMirror[ps.size()];
        int i = 0;
        for (VariableElement variableElement : ps) {
            r[i++] = variableElement.asType();
        }
        return r;
    }

    public boolean isStaticMethod(ExecutableElement m) {
        return this.hasModifier(m, Modifier.STATIC);
    }

    public boolean isFinalMethod(ExecutableElement m) {
        return this.hasModifier(m, Modifier.FINAL);
    }

    private boolean hasModifier(Element d, Modifier mod) {
        return d.getModifiers().contains((Object)mod);
    }

    public boolean isSubClassOf(TypeMirror sub, TypeMirror sup) {
        if (sup == DUMMY) {
            return false;
        }
        return this.env.getTypeUtils().isSubtype(sub, sup);
    }

    private String getSourceClassName(Class clazz) {
        Class<?> d = clazz.getDeclaringClass();
        if (d == null) {
            return clazz.getName();
        }
        String shortName = clazz.getName().substring(d.getName().length() + 1);
        return this.getSourceClassName(d) + '.' + shortName;
    }

    public TypeMirror ref(Class c) {
        if (c.isArray()) {
            return this.env.getTypeUtils().getArrayType(this.ref(c.getComponentType()));
        }
        if (c.isPrimitive()) {
            return this.getPrimitive(c);
        }
        TypeElement t = this.env.getElementUtils().getTypeElement(this.getSourceClassName(c));
        if (t == null) {
            return DUMMY;
        }
        return this.env.getTypeUtils().getDeclaredType(t, new TypeMirror[0]);
    }

    public TypeMirror use(TypeElement t) {
        assert (t != null);
        return this.env.getTypeUtils().getDeclaredType(t, new TypeMirror[0]);
    }

    public TypeElement asDecl(TypeMirror m) {
        m = this.env.getTypeUtils().erasure(m);
        if (m.getKind().equals((Object)TypeKind.DECLARED)) {
            DeclaredType d = (DeclaredType)m;
            return (TypeElement)d.asElement();
        }
        return null;
    }

    public TypeElement asDecl(Class c) {
        return this.env.getElementUtils().getTypeElement(this.getSourceClassName(c));
    }

    public TypeMirror erasure(TypeMirror t) {
        DeclaredType dt;
        Types tu = this.env.getTypeUtils();
        t = tu.erasure(t);
        if (t.getKind().equals((Object)TypeKind.DECLARED) && !(dt = (DeclaredType)t).getTypeArguments().isEmpty()) {
            return tu.getDeclaredType((TypeElement)dt.asElement(), new TypeMirror[0]);
        }
        return t;
    }

    public boolean isAbstract(TypeElement clazz) {
        return this.hasModifier(clazz, Modifier.ABSTRACT);
    }

    public boolean isFinal(TypeElement clazz) {
        return this.hasModifier(clazz, Modifier.FINAL);
    }

    public VariableElement[] getEnumConstants(TypeElement clazz) {
        List<? extends Element> elements = this.env.getElementUtils().getAllMembers(clazz);
        HashSet<VariableElement> constants = new HashSet<VariableElement>();
        for (Element element : elements) {
            if (!element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)) continue;
            constants.add((VariableElement)element);
        }
        return constants.toArray(new VariableElement[constants.size()]);
    }

    public TypeMirror getVoidType() {
        return this.env.getTypeUtils().getNoType(TypeKind.VOID);
    }

    public String getPackageName(TypeElement clazz) {
        return this.env.getElementUtils().getPackageOf(clazz).getQualifiedName().toString();
    }

    public TypeElement loadObjectFactory(TypeElement referencePoint, String packageName) {
        return this.env.getElementUtils().getTypeElement(packageName + ".ObjectFactory");
    }

    public boolean isBridgeMethod(ExecutableElement method) {
        return method.getModifiers().contains((Object)Modifier.VOLATILE);
    }

    public boolean isOverriding(ExecutableElement method, TypeElement base) {
        Elements elements = this.env.getElementUtils();
        while (true) {
            for (ExecutableElement m : ElementFilter.methodsIn(elements.getAllMembers(base))) {
                if (!elements.overrides(method, m, base)) continue;
                return true;
            }
            if (base.getSuperclass().getKind().equals((Object)TypeKind.NONE)) {
                return false;
            }
            base = (TypeElement)this.env.getTypeUtils().asElement(base.getSuperclass());
        }
    }

    public boolean isInterface(TypeElement clazz) {
        return clazz.getKind().isInterface();
    }

    public boolean isTransient(VariableElement f) {
        return f.getModifiers().contains((Object)Modifier.TRANSIENT);
    }

    public boolean isInnerClass(TypeElement clazz) {
        return clazz.getEnclosingElement() != null && !clazz.getModifiers().contains((Object)Modifier.STATIC);
    }

    public boolean isSameType(TypeMirror t1, TypeMirror t2) {
        return this.env.getTypeUtils().isSameType(t1, t2);
    }

    public boolean isArray(TypeMirror type) {
        return type != null && type.getKind().equals((Object)TypeKind.ARRAY);
    }

    public boolean isArrayButNotByteArray(TypeMirror t) {
        if (!this.isArray(t)) {
            return false;
        }
        ArrayType at = (ArrayType)t;
        TypeMirror ct = at.getComponentType();
        return !ct.equals(this.primitiveByte);
    }

    public TypeMirror getComponentType(TypeMirror t) {
        if (this.isArray(t)) {
            ArrayType at = (ArrayType)t;
            return at.getComponentType();
        }
        throw new IllegalArgumentException();
    }

    public TypeMirror getTypeArgument(TypeMirror typeMirror, int i) {
        if (typeMirror != null && typeMirror.getKind().equals((Object)TypeKind.DECLARED)) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeMirror[] args = declaredType.getTypeArguments().toArray(new TypeMirror[declaredType.getTypeArguments().size()]);
            return args[i];
        }
        throw new IllegalArgumentException();
    }

    public boolean isParameterizedType(TypeMirror typeMirror) {
        if (typeMirror != null && typeMirror.getKind().equals((Object)TypeKind.DECLARED)) {
            DeclaredType d = (DeclaredType)typeMirror;
            return !d.getTypeArguments().isEmpty();
        }
        return false;
    }

    public boolean isPrimitive(TypeMirror t) {
        return t.getKind().isPrimitive();
    }

    public TypeMirror getPrimitive(Class primitiveType) {
        assert (primitiveType.isPrimitive());
        if (primitiveType == Void.TYPE) {
            return this.getVoidType();
        }
        return this.env.getTypeUtils().getPrimitiveType(primitives.get(primitiveType));
    }

    public Location getClassLocation(TypeElement typeElement) {
        Trees trees = Trees.instance(this.env);
        return this.getLocation(typeElement.getQualifiedName().toString(), trees.getPath(typeElement));
    }

    public Location getFieldLocation(VariableElement variableElement) {
        return this.getLocation(variableElement);
    }

    public Location getMethodLocation(ExecutableElement executableElement) {
        return this.getLocation(executableElement);
    }

    public boolean hasDefaultConstructor(TypeElement t) {
        if (t == null || !t.getKind().equals((Object)ElementKind.CLASS)) {
            return false;
        }
        for (ExecutableElement init : ElementFilter.constructorsIn(this.env.getElementUtils().getAllMembers(t))) {
            if (!init.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isStaticField(VariableElement f) {
        return this.hasModifier(f, Modifier.STATIC);
    }

    public boolean isPublicMethod(ExecutableElement m) {
        return this.hasModifier(m, Modifier.PUBLIC);
    }

    public boolean isPublicField(VariableElement f) {
        return this.hasModifier(f, Modifier.PUBLIC);
    }

    public boolean isEnum(TypeElement t) {
        return t != null && t.getKind().equals((Object)ElementKind.ENUM);
    }

    private Location getLocation(Element element) {
        Trees trees = Trees.instance(this.env);
        return this.getLocation(((TypeElement)element.getEnclosingElement()).getQualifiedName() + "." + element.getSimpleName(), trees.getPath(element));
    }

    private Location getLocation(final String name, final TreePath treePath) {
        return new Location(){

            public String toString() {
                if (treePath == null) {
                    return name + " (Unknown Source)";
                }
                CompilationUnitTree compilationUnit = treePath.getCompilationUnit();
                Trees trees = Trees.instance(ApNavigator.this.env);
                long startPosition = trees.getSourcePositions().getStartPosition(compilationUnit, treePath.getLeaf());
                return name + "(" + compilationUnit.getSourceFile().getName() + ":" + compilationUnit.getLineMap().getLineNumber(startPosition) + ")";
            }
        };
    }

    static {
        primitives.put(Integer.TYPE, TypeKind.INT);
        primitives.put(Byte.TYPE, TypeKind.BYTE);
        primitives.put(Float.TYPE, TypeKind.FLOAT);
        primitives.put(Boolean.TYPE, TypeKind.BOOLEAN);
        primitives.put(Short.TYPE, TypeKind.SHORT);
        primitives.put(Long.TYPE, TypeKind.LONG);
        primitives.put(Double.TYPE, TypeKind.DOUBLE);
        primitives.put(Character.TYPE, TypeKind.CHAR);
        DUMMY = new TypeMirror(){

            @Override
            public <R, P> R accept(TypeVisitor<R, P> v, P p) {
                throw new IllegalStateException();
            }

            @Override
            public TypeKind getKind() {
                throw new IllegalStateException();
            }

            @Override
            public List<? extends AnnotationMirror> getAnnotationMirrors() {
                throw new IllegalStateException();
            }

            @Override
            public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
                throw new IllegalStateException();
            }

            @Override
            public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
                throw new IllegalStateException();
            }
        };
    }
}

