/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.messages;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import org.keycloak.messages.MessagesProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.ServicesLogger;

public class AdminMessagesProvider
implements MessagesProvider {
    private static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    private KeycloakSession session;
    private Locale locale;
    private Properties messagesBundle;

    public AdminMessagesProvider(KeycloakSession session, Locale locale) {
        this.session = session;
        this.locale = locale;
        this.messagesBundle = this.getMessagesBundle(locale);
    }

    @Override
    public String getMessage(String messageKey, Object ... parameters) {
        String message = this.messagesBundle.getProperty(messageKey, messageKey);
        try {
            return new MessageFormat(message, this.locale).format(parameters);
        }
        catch (Exception e) {
            logger.failedToFormatMessage(e.getMessage());
            return message;
        }
    }

    public void close() {
    }

    private Properties getMessagesBundle(Locale locale) {
        Properties properties = new Properties();
        if (locale == null) {
            return properties;
        }
        URL url = this.getClass().getClassLoader().getResource("theme/base/admin/messages/messages_" + locale.toString() + ".properties");
        if (url != null) {
            try {
                properties.load(url.openStream());
            }
            catch (IOException ex) {
                logger.failedToloadMessages(ex);
            }
        }
        return properties;
    }
}

