/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.CacheRealmProviderFactory;
import org.keycloak.models.cache.infinispan.StreamCacheRealmProvider;
import org.keycloak.models.cache.infinispan.StreamRealmCache;

public class InfinispanCacheRealmProviderFactory
implements CacheRealmProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanCacheRealmProviderFactory.class);
    protected volatile StreamRealmCache realmCache;

    public CacheRealmProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new StreamCacheRealmProvider(this.realmCache, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.realmCache == null) {
            InfinispanCacheRealmProviderFactory infinispanCacheRealmProviderFactory = this;
            synchronized (infinispanCacheRealmProviderFactory) {
                if (this.realmCache == null) {
                    Cache cache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("realms");
                    Cache revisions = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("realmVersions");
                    this.realmCache = new StreamRealmCache(cache, revisions);
                }
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }
}

