/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.models.cache.infinispan.InfinispanCacheUserProviderFactory;
import org.keycloak.models.cache.infinispan.UserCache;
import org.keycloak.models.cache.infinispan.entities.CachedUser;

public class InfinispanUserCache
implements UserCache {
    protected static final Logger logger = Logger.getLogger(InfinispanUserCache.class);
    protected volatile boolean enabled = true;
    protected final Cache<String, CachedUser> cache;
    protected final InfinispanCacheUserProviderFactory.RealmLookup usernameLookup;
    protected final InfinispanCacheUserProviderFactory.RealmLookup emailLookup;

    public InfinispanUserCache(Cache<String, CachedUser> cache, InfinispanCacheUserProviderFactory.RealmLookup usernameLookup, InfinispanCacheUserProviderFactory.RealmLookup emailLookup) {
        this.cache = cache;
        this.usernameLookup = usernameLookup;
        this.emailLookup = emailLookup;
    }

    @Override
    public CachedUser getCachedUser(String realmId, String id) {
        if (realmId == null || id == null) {
            return null;
        }
        CachedUser user = (CachedUser)this.cache.get((Object)id);
        return user != null && realmId.equals(user.getRealm()) ? user : null;
    }

    @Override
    public void invalidateCachedUserById(String realmId, String id) {
        logger.tracev("Invalidating user {0}", (Object)id);
        this.cache.remove((Object)id);
    }

    @Override
    public void addCachedUser(String realmId, CachedUser user) {
        logger.tracev("Adding user {0}", (Object)user.getId());
        this.cache.putForExternalRead((Object)user.getId(), (Object)user);
    }

    @Override
    public CachedUser getCachedUserByUsername(String realmId, String name) {
        String id = this.usernameLookup.get(realmId, name);
        return id != null ? this.getCachedUser(realmId, id) : null;
    }

    @Override
    public CachedUser getCachedUserByEmail(String realmId, String email) {
        String id = this.emailLookup.get(realmId, email);
        return id != null ? this.getCachedUser(realmId, id) : null;
    }

    @Override
    public void invalidateRealmUsers(String realmId) {
        logger.tracev("Invalidating users for realm {0}", (Object)realmId);
        this.cache.clear();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

