/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.lock;

import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.Time;
import org.keycloak.connections.jpa.updater.liquibase.lock.LiquibaseDBLockProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.dblock.DBLockProviderFactory;

public class LiquibaseDBLockProviderFactory
implements DBLockProviderFactory {
    private static final Logger logger = Logger.getLogger(LiquibaseDBLockProviderFactory.class);
    private long lockRecheckTimeMillis;
    private long lockWaitTimeoutMillis;

    protected long getLockRecheckTimeMillis() {
        return this.lockRecheckTimeMillis;
    }

    protected long getLockWaitTimeoutMillis() {
        return this.lockWaitTimeoutMillis;
    }

    public void init(Config.Scope config) {
        int lockRecheckTime = config.getInt("lockRecheckTime", Integer.valueOf(2));
        int lockWaitTimeout = config.getInt("lockWaitTimeout", Integer.valueOf(900));
        this.lockRecheckTimeMillis = Time.toMillis((int)lockRecheckTime);
        this.lockWaitTimeoutMillis = Time.toMillis((int)lockWaitTimeout);
        logger.debugf("Liquibase lock provider configured with lockWaitTime: %d seconds, lockRecheckTime: %d seconds", lockWaitTimeout, lockRecheckTime);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public LiquibaseDBLockProvider create(KeycloakSession session) {
        return new LiquibaseDBLockProvider(this, session);
    }

    public void setTimeouts(long lockRecheckTimeMillis, long lockWaitTimeoutMillis) {
        this.lockRecheckTimeMillis = lockRecheckTimeMillis;
        this.lockWaitTimeoutMillis = lockWaitTimeoutMillis;
    }

    public void close() {
    }

    public String getId() {
        return "jpa";
    }
}

