/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RealmProviderFactory;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.dblock.DBLockProviderFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.ServicesLogger;

public class DBLockManager {
    protected static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;

    public void waitForLock(KeycloakSessionFactory sessionFactory) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                DBLockProvider lock = DBLockManager.this.getDBLock(session);
                lock.waitForLock();
            }
        });
    }

    public void releaseLock(KeycloakSessionFactory sessionFactory) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                DBLockProvider lock = DBLockManager.this.getDBLock(session);
                lock.releaseLock();
            }
        });
    }

    public void checkForcedUnlock(KeycloakSessionFactory sessionFactory) {
        if (Boolean.getBoolean("keycloak.dblock.forceUnlock")) {
            logger.forcedReleaseDBLock();
            this.releaseLock(sessionFactory);
        }
    }

    public DBLockProvider getDBLock(KeycloakSession session) {
        String realmProviderId = this.getRealmProviderId(session);
        return (DBLockProvider)session.getProvider(DBLockProvider.class, realmProviderId);
    }

    public DBLockProviderFactory getDBLockFactory(KeycloakSession session) {
        String realmProviderId = this.getRealmProviderId(session);
        return (DBLockProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(DBLockProvider.class, realmProviderId);
    }

    private String getRealmProviderId(KeycloakSession session) {
        RealmProviderFactory realmProviderFactory = (RealmProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(RealmProvider.class);
        return realmProviderFactory.getId();
    }
}

