CREATE TABLE JOB_INSTANCE (
  JOBINSTANCEID   BIGINT PRIMARY KEY NOT NULL,
  VERSION         INTEGER,
  JOBNAME         VARCHAR(512),
  APPLICATIONNAME VARCHAR(512)
);!!

CREATE GENERATOR JOBINSTANCEID_GEN;!!
SET GENERATOR JOBINSTANCEID_GEN TO 0;!!
CREATE TRIGGER JOB_INSTANCE_BI FOR JOB_INSTANCE
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  NEW.JOBINSTANCEID = GEN_ID(JOBINSTANCEID_GEN, 1);
END;!!

CREATE TABLE JOB_EXECUTION (
  JOBEXECUTIONID  BIGINT PRIMARY KEY NOT NULL,
  JOBINSTANCEID   BIGINT             NOT NULL,
  VERSION         INTEGER,
  CREATETIME      TIMESTAMP,
  STARTTIME       TIMESTAMP,
  ENDTIME         TIMESTAMP,
  LASTUPDATEDTIME TIMESTAMP,
  BATCHSTATUS     VARCHAR(30),
  EXITSTATUS      VARCHAR(512),
  JOBPARAMETERS   VARCHAR(3000),
  RESTARTPOSITION VARCHAR(255),
  CONSTRAINT FK_JOB_EXECUTION_JOB_INSTANCE FOREIGN KEY (JOBINSTANCEID) REFERENCES JOB_INSTANCE (JOBINSTANCEID) ON DELETE CASCADE
);!!

CREATE GENERATOR JOBEXECUTIONID_GEN;!!
SET GENERATOR JOBEXECUTIONID_GEN TO 0;!!
CREATE TRIGGER JOB_EXECUTION_BI FOR JOB_EXECUTION
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  NEW.JOBEXECUTIONID = GEN_ID(JOBEXECUTIONID_GEN, 1);
END;!!

CREATE TABLE STEP_EXECUTION (
  STEPEXECUTIONID    BIGINT PRIMARY KEY NOT NULL,
  JOBEXECUTIONID     BIGINT             NOT NULL,
  VERSION            INTEGER,
  STEPNAME           VARCHAR(255),
  STARTTIME          TIMESTAMP,
  ENDTIME            TIMESTAMP,
  BATCHSTATUS        VARCHAR(30),
  EXITSTATUS         VARCHAR(512),
  EXECUTIONEXCEPTION VARCHAR(2048),
  PERSISTENTUSERDATA BLOB,
  READCOUNT          INTEGER,
  WRITECOUNT         INTEGER,
  COMMITCOUNT        INTEGER,
  ROLLBACKCOUNT      INTEGER,
  READSKIPCOUNT      INTEGER,
  PROCESSSKIPCOUNT   INTEGER,
  FILTERCOUNT        INTEGER,
  WRITESKIPCOUNT     INTEGER,
  READERCHECKPOINTINFO  BLOB,
  WRITERCHECKPOINTINFO  BLOB,
  CONSTRAINT FK_STEP_EXE_JOB_EXE FOREIGN KEY (JOBEXECUTIONID) REFERENCES JOB_EXECUTION (JOBEXECUTIONID) ON DELETE CASCADE
);!!

CREATE GENERATOR STEPEXECUTIONID_GEN;!!
SET GENERATOR STEPEXECUTIONID_GEN TO 0;!!
CREATE TRIGGER STEP_EXECUTION_BI FOR STEP_EXECUTION
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  NEW.STEPEXECUTIONID = GEN_ID(STEPEXECUTIONID_GEN, 1);
END;!!

CREATE TABLE PARTITION_EXECUTION (
  PARTITIONEXECUTIONID  INTEGER NOT NULL,
  STEPEXECUTIONID       BIGINT  NOT NULL,
  VERSION               INTEGER,
  BATCHSTATUS           VARCHAR(30),
  EXITSTATUS            VARCHAR(512),
  EXECUTIONEXCEPTION    VARCHAR(2048),
  PERSISTENTUSERDATA    BLOB,
  READERCHECKPOINTINFO  BLOB,
  WRITERCHECKPOINTINFO  BLOB,
  PRIMARY KEY (PARTITIONEXECUTIONID, STEPEXECUTIONID),
  CONSTRAINT FK_PARTITION_EXE_STEP_EXE FOREIGN KEY (STEPEXECUTIONID) REFERENCES STEP_EXECUTION (STEPEXECUTIONID) ON DELETE CASCADE
);!!

