/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery;

import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.common.internal.util.ClassloadingUtility;
import com.arjuna.orbportability.ORBInfo;
import com.arjuna.orbportability.common.opPropertyManager;
import java.util.List;

public class RecoveryInit {
    private static boolean _initialised = false;
    private static boolean _isNormalProcess = true;

    public RecoveryInit() {
        if (!_initialised) {
            _initialised = true;
            String eventHandlerClassName = "com.arjuna.ats.internal.jts.recovery.contact.RecoveryContactWriter";
            if (_isNormalProcess) {
                try {
                    String initClassName;
                    int orbType = ORBInfo.getOrbEnumValue();
                    switch (orbType) {
                        case 4: {
                            initClassName = "com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators.JacOrbRecoveryInit";
                            break;
                        }
                        case 1: {
                            initClassName = "com.arjuna.ats.internal.jts.orbspecific.javaidl.recoverycoordinators.JavaIdlRecoveryInit";
                            break;
                        }
                        case 5: {
                            initClassName = "com.arjuna.ats.internal.jts.orbspecific.ibmorb.recoverycoordinators.JavaIdlRecoveryInit";
                            break;
                        }
                        default: {
                            initClassName = null;
                            jtsLogger.i18NLogger.warn_recovery_recoveryinit_1();
                        }
                    }
                    if (initClassName != null) {
                        Class recoveryCoordinatorInitialiser = ClassloadingUtility.loadClass(initClassName);
                        recoveryCoordinatorInitialiser.newInstance();
                    }
                    List<String> eventHandlers = opPropertyManager.getOrbPortabilityEnvironmentBean().getEventHandlerClassNames();
                    eventHandlers.add(eventHandlerClassName);
                    opPropertyManager.getOrbPortabilityEnvironmentBean().setEventHandlerClassNames(eventHandlers);
                }
                catch (Exception e) {
                    jtsLogger.i18NLogger.fatal_recovery_RecoveryInit_4();
                    throw new FatalError(e.toString(), e);
                }
                if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug((Object)"added ORBAttribute for recoveryCoordinatorInitialiser");
                    jtsLogger.logger.debug((Object)("added event handler " + eventHandlerClassName));
                }
            }
        }
    }

    public static void isNotANormalProcess() {
        _isNormalProcess = false;
    }

    public static boolean isNormalProcess() {
        return _isNormalProcess;
    }
}

