/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.keycloak.Config;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.clientregistration.ClientRegistrationTokenUtils;

public class ClientRegistrationAuth {
    private KeycloakSession session;
    private EventBuilder event;
    private RealmModel realm;
    private JsonWebToken jwt;
    private ClientInitialAccessModel initialAccessModel;

    public ClientRegistrationAuth(KeycloakSession session, EventBuilder event) {
        this.session = session;
        this.event = event;
        this.init();
    }

    private void init() {
        this.realm = this.session.getContext().getRealm();
        UriInfo uri = this.session.getContext().getUri();
        String authorizationHeader = (String)this.session.getContext().getRequestHeaders().getRequestHeaders().getFirst((Object)"Authorization");
        if (authorizationHeader == null) {
            return;
        }
        String[] split = authorizationHeader.split(" ");
        if (!split[0].equalsIgnoreCase("bearer")) {
            return;
        }
        this.jwt = ClientRegistrationTokenUtils.parseToken(this.realm, uri, split[1]);
        if (this.isInitialAccessToken()) {
            this.initialAccessModel = this.session.sessions().getClientInitialAccessModel(this.session.getContext().getRealm(), this.jwt.getId());
            if (this.initialAccessModel == null) {
                throw new ForbiddenException();
            }
        }
    }

    public boolean isAuthenticated() {
        return this.jwt != null;
    }

    public boolean isBearerToken() {
        return "Bearer".equals(this.jwt.getType());
    }

    public boolean isInitialAccessToken() {
        return "InitialAccessToken".equals(this.jwt.getType());
    }

    public boolean isRegistrationAccessToken() {
        return "RegistrationAccessToken".equals(this.jwt.getType());
    }

    public void requireCreate() {
        if (!this.isAuthenticated()) {
            this.event.error("not_allowed");
            throw new UnauthorizedException();
        }
        if (this.isBearerToken() ? this.hasRole(AdminRoles.MANAGE_CLIENTS, AdminRoles.CREATE_CLIENT) : this.isInitialAccessToken() && this.initialAccessModel.getRemainingCount() > 0 && (this.initialAccessModel.getExpiration() == 0 || this.initialAccessModel.getTimestamp() + this.initialAccessModel.getExpiration() > Time.currentTime())) {
            return;
        }
        this.event.error("not_allowed");
        throw new ForbiddenException();
    }

    public void requireView(ClientModel client) {
        if (!this.isAuthenticated()) {
            this.event.error("not_allowed");
            throw new UnauthorizedException();
        }
        if (client == null) {
            this.event.error("not_allowed");
            throw new ForbiddenException();
        }
        if (this.isBearerToken() ? this.hasRole(AdminRoles.MANAGE_CLIENTS, AdminRoles.VIEW_CLIENTS) : this.isRegistrationAccessToken() && client.getRegistrationToken() != null && client.getRegistrationToken().equals(this.jwt.getId())) {
            return;
        }
        this.event.error("not_allowed");
        throw new ForbiddenException();
    }

    public void requireUpdate(ClientModel client) {
        if (!this.isAuthenticated()) {
            this.event.error("not_allowed");
            throw new UnauthorizedException();
        }
        if (client == null) {
            this.event.error("not_allowed");
            throw new ForbiddenException();
        }
        if (this.isBearerToken() ? this.hasRole(AdminRoles.MANAGE_CLIENTS) : this.isRegistrationAccessToken() && client.getRegistrationToken() != null && client.getRegistrationToken().equals(this.jwt.getId())) {
            return;
        }
        this.event.error("not_allowed");
        throw new ForbiddenException();
    }

    public ClientInitialAccessModel getInitialAccessModel() {
        return this.initialAccessModel;
    }

    private boolean hasRole(String ... role) {
        try {
            Map otherClaims = this.jwt.getOtherClaims();
            if (otherClaims != null) {
                Map resourceAccess = (Map)this.jwt.getOtherClaims().get("resource_access");
                if (resourceAccess == null) {
                    return false;
                }
                List roles = null;
                Map map = this.realm.getName().equals(Config.getAdminRealm()) ? (Map)resourceAccess.get(this.realm.getMasterAdminClient().getClientId()) : (Map)resourceAccess.get("realm-management");
                if (map != null) {
                    roles = (List)map.get("roles");
                }
                if (roles == null) {
                    return false;
                }
                for (String r : role) {
                    if (!roles.contains(r)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

