/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.lock;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.text.DateFormat;
import liquibase.database.core.DerbyDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LockException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.StandardLockService;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.DropTableStatement;
import liquibase.statement.core.InitializeDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.RawSqlStatement;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.connections.jpa.updater.liquibase.lock.LockRetryException;

public class CustomLockService
extends StandardLockService {
    private static final Logger log = Logger.getLogger(CustomLockService.class);
    private long changeLogLocRecheckTimeMillis = -1L;

    public void setChangeLogLockRecheckTime(long changeLogLocRecheckTime) {
        super.setChangeLogLockRecheckTime(changeLogLocRecheckTime);
        this.changeLogLocRecheckTimeMillis = changeLogLocRecheckTime;
    }

    public Long getChangeLogLockRecheckTime() {
        if (this.changeLogLocRecheckTimeMillis == -1L) {
            return super.getChangeLogLockRecheckTime();
        }
        return this.changeLogLocRecheckTimeMillis;
    }

    public void init() throws DatabaseException {
        boolean createdTable = false;
        Executor executor = ExecutorService.getInstance().getExecutor(this.database);
        if (!this.hasDatabaseChangeLogLockTable()) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Create Database Lock Table");
                }
                executor.execute((SqlStatement)new CreateDatabaseChangeLogLockTableStatement());
                this.database.commit();
            }
            catch (DatabaseException de) {
                log.warn((Object)"Failed to create lock table. Maybe other transaction created in the meantime. Retrying...");
                if (log.isDebugEnabled()) {
                    log.debug((Object)de.getMessage(), (Throwable)de);
                }
                this.database.rollback();
                throw new LockRetryException(de);
            }
            log.debugf("Created database lock table with name: %s", (Object)this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName()));
            try {
                Field field = Reflections.findDeclaredField(StandardLockService.class, (String)"hasDatabaseChangeLogLockTable");
                Reflections.setAccessible((AccessibleObject)field);
                field.set((Object)this, true);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            createdTable = true;
        }
        if (!this.isDatabaseChangeLogLockTableInitialized(createdTable)) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Initialize Database Lock Table");
                }
                executor.execute((SqlStatement)new InitializeDatabaseChangeLogLockTableStatement());
                this.database.commit();
            }
            catch (DatabaseException de) {
                log.warn((Object)"Failed to insert first record to the lock table. Maybe other transaction inserted in the meantime. Retrying...");
                if (log.isDebugEnabled()) {
                    log.debug((Object)de.getMessage(), (Throwable)de);
                }
                this.database.rollback();
                throw new LockRetryException(de);
            }
            log.debug((Object)"Initialized record in the database lock table");
        }
        if (executor.updatesDatabase() && this.database instanceof DerbyDatabase && ((DerbyDatabase)this.database).supportsBooleanDataType()) {
            String lockTable = this.database.escapeTableName(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName());
            Object obj = executor.queryForObject((SqlStatement)new RawSqlStatement("select min(locked) as test from " + lockTable + " fetch first row only"), Object.class);
            if (!(obj instanceof Boolean)) {
                executor.execute((SqlStatement)new DropTableStatement(this.database.getLiquibaseCatalogName(), this.database.getLiquibaseSchemaName(), this.database.getDatabaseChangeLogLockTableName(), false));
                executor.execute((SqlStatement)new CreateDatabaseChangeLogLockTableStatement());
                executor.execute((SqlStatement)new InitializeDatabaseChangeLogLockTableStatement());
            }
        }
    }

    public void waitForLock() throws LockException {
        boolean locked = false;
        long startTime = Time.toMillis((int)Time.currentTime());
        long timeToGiveUp = startTime + this.getChangeLogLockWaitTime();
        while (!locked && Time.toMillis((int)Time.currentTime()) < timeToGiveUp) {
            locked = this.acquireLock();
            if (locked) continue;
            int remainingTime = (int)(timeToGiveUp / 1000L) - Time.currentTime();
            log.debugf("Waiting for changelog lock... Remaining time: %d seconds", remainingTime);
            try {
                Thread.sleep(this.getChangeLogLockRecheckTime());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (!locked) {
            String lockedBy;
            DatabaseChangeLogLock[] locks = this.listLocks();
            if (locks.length > 0) {
                DatabaseChangeLogLock lock = locks[0];
                lockedBy = lock.getLockedBy() + " since " + DateFormat.getDateTimeInstance(3, 3).format(lock.getLockGranted());
            } else {
                lockedBy = "UNKNOWN";
            }
            throw new LockException("Could not acquire change log lock.  Currently locked by " + lockedBy);
        }
    }
}

