/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.KeycloakTransactionManager;

public class KeycloakSessionServletFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        servletRequest.setCharacterEncoding("UTF-8");
        final HttpServletRequest request = (HttpServletRequest)servletRequest;
        KeycloakSessionFactory sessionFactory = (KeycloakSessionFactory)servletRequest.getServletContext().getAttribute(KeycloakSessionFactory.class.getName());
        KeycloakSession session = sessionFactory.create();
        ResteasyProviderFactory.pushContext(KeycloakSession.class, (Object)session);
        ClientConnection connection = new ClientConnection(){

            public String getRemoteAddr() {
                return request.getRemoteAddr();
            }

            public String getRemoteHost() {
                return request.getRemoteHost();
            }

            public int getReportPort() {
                return request.getRemotePort();
            }
        };
        session.getContext().setConnection(connection);
        ResteasyProviderFactory.pushContext(ClientConnection.class, (Object)connection);
        KeycloakTransactionManager tx = session.getTransaction();
        ResteasyProviderFactory.pushContext(KeycloakTransaction.class, (Object)tx);
        tx.begin();
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            if (session.getTransaction() != null && session.getTransaction().isActive()) {
                session.getTransaction().rollback();
            }
            session.close();
            ResteasyProviderFactory.clearContextData();
        }
    }

    public void destroy() {
    }
}

