/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.keycloak.Config;
import org.keycloak.common.util.MimeTypeUtil;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.theme.BrowserSecurityHeaderSetup;
import org.keycloak.theme.FreeMarkerUtil;
import org.keycloak.theme.Theme;
import org.keycloak.theme.ThemeProvider;

@Path(value="/")
public class WelcomeResource {
    private static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    private static final String KEYCLOAK_STATE_CHECKER = "KEYCLOAK_STATE_CHECKER";
    private boolean bootstrap;
    @Context
    protected HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private KeycloakSession session;
    private String stateChecker;

    public WelcomeResource(boolean bootstrap) {
        this.bootstrap = bootstrap;
    }

    @GET
    @Produces(value={"text/html; charset=utf-8"})
    public Response getWelcomePage() throws URISyntaxException {
        this.checkBootstrap();
        String requestUri = this.uriInfo.getRequestUri().toString();
        if (!requestUri.endsWith("/")) {
            return Response.seeOther((URI)new URI(requestUri + "/")).build();
        }
        return this.createWelcomePage(null, null);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createUser(MultivaluedMap<String, String> formData) {
        this.checkBootstrap();
        if (!this.bootstrap) {
            return this.createWelcomePage(null, null);
        }
        if (!this.isLocal()) {
            logger.rejectedNonLocalAttemptToCreateInitialUser(this.session.getContext().getConnection().getRemoteAddr());
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String stateChecker = (String)formData.getFirst((Object)"stateChecker");
        this.csrfCheck(stateChecker);
        String username = (String)formData.getFirst((Object)"username");
        String password = (String)formData.getFirst((Object)"password");
        String passwordConfirmation = (String)formData.getFirst((Object)"passwordConfirmation");
        if (username == null || username.length() == 0) {
            return this.createWelcomePage(null, "Username is missing");
        }
        if (password == null || password.length() == 0) {
            return this.createWelcomePage(null, "Password is missing");
        }
        if (!password.equals(passwordConfirmation)) {
            return this.createWelcomePage(null, "Password and confirmation doesn't match");
        }
        ApplianceBootstrap applianceBootstrap = new ApplianceBootstrap(this.session);
        if (applianceBootstrap.isNoMasterUser()) {
            this.bootstrap = false;
            applianceBootstrap.createMasterRealmUser(username, password);
            logger.createdInitialAdminUser(username);
            return this.createWelcomePage("User created", null);
        }
        logger.initialUserAlreadyCreated();
        return this.createWelcomePage(null, "Users already exists");
    }

    @GET
    @Path(value="/welcome-content/{path}")
    @Produces(value={"text/html; charset=utf-8"})
    public Response getResource(@PathParam(value="path") String path) {
        try {
            InputStream resource = this.getTheme().getResourceAsStream(path);
            if (resource != null) {
                String contentType = MimeTypeUtil.getContentType((String)path);
                Response.ResponseBuilder builder = Response.ok((Object)resource).type(contentType).cacheControl(CacheControlUtil.getDefaultCacheControl());
                return builder.build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IOException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response createWelcomePage(String successMessage, String errorMessage) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bootstrap", this.bootstrap);
            if (this.bootstrap) {
                map.put("localUser", this.isLocal());
                this.updateCsrfChecks();
                map.put("stateChecker", this.stateChecker);
            }
            if (successMessage != null) {
                map.put("successMessage", successMessage);
            }
            if (errorMessage != null) {
                map.put("errorMessage", errorMessage);
            }
            FreeMarkerUtil freeMarkerUtil = new FreeMarkerUtil();
            String result = freeMarkerUtil.processTemplate(map, "index.ftl", this.getTheme());
            Response.ResponseBuilder rb = Response.status((Response.Status)(errorMessage == null ? Response.Status.OK : Response.Status.BAD_REQUEST)).entity((Object)result).cacheControl(CacheControlUtil.noCache());
            BrowserSecurityHeaderSetup.headers(rb, BrowserSecurityHeaders.defaultHeaders);
            return rb.build();
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Theme getTheme() {
        Config.Scope config = Config.scope((String[])new String[]{"theme"});
        ThemeProvider themeProvider = (ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending");
        try {
            return themeProvider.getTheme(config.get("welcomeTheme"), Theme.Type.WELCOME);
        }
        catch (IOException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void checkBootstrap() {
        if (this.bootstrap) {
            this.bootstrap = new ApplianceBootstrap(this.session).isNoMasterUser();
        }
    }

    private boolean isLocal() {
        try {
            InetAddress inetAddress = InetAddress.getByName(this.session.getContext().getConnection().getRemoteAddr());
            return inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void updateCsrfChecks() {
        Cookie cookie = (Cookie)this.headers.getCookies().get(KEYCLOAK_STATE_CHECKER);
        if (cookie != null) {
            this.stateChecker = cookie.getValue();
        } else {
            this.stateChecker = KeycloakModelUtils.generateSecret();
            String cookiePath = this.uriInfo.getPath();
            boolean secureOnly = this.uriInfo.getRequestUri().getScheme().equalsIgnoreCase("https");
            CookieHelper.addCookie(KEYCLOAK_STATE_CHECKER, this.stateChecker, cookiePath, null, null, -1, secureOnly, true);
        }
    }

    private void csrfCheck(String stateChecker) {
        if (!this.stateChecker.equals(stateChecker)) {
            throw new ForbiddenException();
        }
    }
}

