/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal.authentication.schemes.support;

import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.picketlink.http.internal.authentication.schemes.support.SavedRequest;

public class RequestCache {
    public static final String ORIGINAL_REQUEST_ATTRIBUTE_NAME = "org.picketlink.web.original.request";
    private ConcurrentHashMap<String, SavedRequest> requestCache = new ConcurrentHashMap();

    public void saveRequest(HttpServletRequest request) {
        this.requestCache.put(this.getCurrentSession(request).getId(), new SavedRequest(request));
    }

    private HttpSession getCurrentSession(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        if (session == null) {
            throw new IllegalStateException("Unable to cache the request. User session was not created.");
        }
        return session;
    }

    public SavedRequest removeAndStoreSavedRequestInSession(HttpServletRequest request) {
        HttpSession session = this.getCurrentSession(request);
        SavedRequest originalRequest = this.requestCache.remove(session.getId());
        session.setAttribute(ORIGINAL_REQUEST_ATTRIBUTE_NAME, (Object)originalRequest);
        return originalRequest;
    }
}

