/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.ModelException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.managers.UserManager;

public class UserFederationManager
implements UserProvider {
    private static final Logger logger = Logger.getLogger(UserFederationManager.class);
    protected KeycloakSession session;
    private Map<String, UserModel> managedUsers = new HashMap<String, UserModel>();

    public UserFederationManager(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        UserModel user = this.session.userStorage().addUser(realm, id, username.toLowerCase(), addDefaultRoles, addDefaultRequiredActions);
        return this.registerWithFederation(realm, user);
    }

    protected UserFederationProvider getFederationProvider(UserFederationProviderModel model) {
        return KeycloakModelUtils.getFederationProviderInstance(this.session, model);
    }

    @Override
    public UserModel addUser(RealmModel realm, String username) {
        UserModel user = this.session.userStorage().addUser(realm, username.toLowerCase());
        return this.registerWithFederation(realm, user);
    }

    protected UserModel registerWithFederation(RealmModel realm, UserModel user) {
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            if (!fed.synchronizeRegistrations()) continue;
            user.setFederationLink(federation.getId());
            UserModel registered = fed.register(realm, user);
            this.managedUsers.put(registered.getId(), registered);
            return registered;
        }
        return user;
    }

    protected UserFederationProvider getFederationLink(RealmModel realm, UserModel user) {
        if (user.getFederationLink() == null) {
            return null;
        }
        for (UserFederationProviderModel fed : realm.getUserFederationProviders()) {
            if (!fed.getId().equals(user.getFederationLink())) continue;
            return this.getFederationProvider(fed);
        }
        return null;
    }

    @Override
    public boolean removeUser(RealmModel realm, UserModel user) {
        UserFederationProvider link = this.getFederationLink(realm, user);
        if (link != null) {
            boolean fedRemoved = link.removeUser(realm, user);
            if (fedRemoved) {
                boolean localRemoved = this.session.userStorage().removeUser(realm, user);
                this.managedUsers.remove(user.getId());
                if (!localRemoved) {
                    logger.warn((Object)"User possibly removed from federation provider, but failed to remove him from keycloak model");
                }
                return localRemoved;
            }
            logger.warn((Object)"Failed to remove user from federation provider");
            return false;
        }
        return this.session.userStorage().removeUser(realm, user);
    }

    protected void validateUser(RealmModel realm, UserModel user) {
        if (this.managedUsers.containsKey(user.getId())) {
            return;
        }
        UserFederationProvider link = this.getFederationLink(realm, user);
        if (link != null && !link.isValid(realm, user)) {
            this.deleteInvalidUser(realm, user);
            throw new IllegalStateException("Federated user no longer valid");
        }
    }

    protected void deleteInvalidUser(final RealmModel realm, final UserModel user) {
        KeycloakModelUtils.runJobInTransaction(this.session.getKeycloakSessionFactory(), new KeycloakSessionTask(){

            @Override
            public void run(KeycloakSession session) {
                RealmModel realmModel = session.realms().getRealm(realm.getId());
                if (realmModel == null) {
                    return;
                }
                UserModel deletedUser = session.userStorage().getUserById(user.getId(), realmModel);
                new UserManager(session).removeUser(realmModel, deletedUser, session.userStorage());
                logger.debugf("Removed invalid user '%s'", (Object)user.getUsername());
            }
        });
    }

    protected UserModel validateAndProxyUser(RealmModel realm, UserModel user) {
        UserModel managed = this.managedUsers.get(user.getId());
        if (managed != null) {
            return managed;
        }
        UserFederationProvider link = this.getFederationLink(realm, user);
        if (link != null) {
            UserModel validatedProxyUser = link.validateAndProxy(realm, user);
            if (validatedProxyUser != null) {
                this.managedUsers.put(user.getId(), validatedProxyUser);
                return validatedProxyUser;
            }
            this.deleteInvalidUser(realm, user);
            return null;
        }
        return user;
    }

    @Override
    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel socialLink) {
        this.validateUser(realm, user);
        this.session.userStorage().addFederatedIdentity(realm, user, socialLink);
    }

    @Override
    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        this.session.userStorage().updateFederatedIdentity(realm, federatedUser, federatedIdentityModel);
    }

    @Override
    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        this.validateUser(realm, user);
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        return this.session.userStorage().removeFederatedIdentity(realm, user, socialProvider);
    }

    @Override
    public UserModel getUserById(String id, RealmModel realm) {
        UserModel user = this.session.userStorage().getUserById(id, realm);
        if (user != null) {
            user = this.validateAndProxyUser(realm, user);
        }
        return user;
    }

    @Override
    public List<UserModel> getGroupMembers(RealmModel realm, final GroupModel group, int firstResult, int maxResults) {
        int maxTotal = firstResult + maxResults;
        List<UserModel> localMembers = this.query(new PaginatedQuery(){

            @Override
            public List<UserModel> query(RealmModel realm, int first, int max) {
                return UserFederationManager.this.session.userStorage().getGroupMembers(realm, group, first, max);
            }
        }, realm, 0, maxTotal);
        LinkedHashSet<UserModel> result = new LinkedHashSet<UserModel>(localMembers);
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            if (result.size() >= maxTotal) break;
            int max = maxTotal - result.size();
            UserFederationProvider fed = this.getFederationProvider(federation);
            List<UserModel> current = fed.getGroupMembers(realm, group, 0, max);
            if (current == null) continue;
            result.addAll(current);
        }
        if (result.size() <= firstResult) {
            return Collections.emptyList();
        }
        int max = Math.min(maxTotal, result.size());
        return new ArrayList<UserModel>(result).subList(firstResult, max);
    }

    @Override
    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
        return this.getGroupMembers(realm, group, -1, -1);
    }

    @Override
    public UserModel getUserByUsername(String username, RealmModel realm) {
        UserModel user = this.session.userStorage().getUserByUsername(username.toLowerCase(), realm);
        if (user != null && (user = this.validateAndProxyUser(realm, user)) != null) {
            return user;
        }
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            user = fed.getUserByUsername(realm, username);
            if (user == null) continue;
            return user;
        }
        return user;
    }

    @Override
    public UserModel getUserByEmail(String email, RealmModel realm) {
        UserModel user = this.session.userStorage().getUserByEmail(email.toLowerCase(), realm);
        if (user != null && (user = this.validateAndProxyUser(realm, user)) != null) {
            return user;
        }
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            user = fed.getUserByEmail(realm, email);
            if (user == null) continue;
            return user;
        }
        return user;
    }

    @Override
    public UserModel getUserByFederatedIdentity(FederatedIdentityModel socialLink, RealmModel realm) {
        UserModel user = this.session.userStorage().getUserByFederatedIdentity(socialLink, realm);
        if (user != null) {
            user = this.validateAndProxyUser(realm, user);
        }
        return user;
    }

    @Override
    public UserModel getUserByServiceAccountClient(ClientModel client) {
        UserModel user = this.session.userStorage().getUserByServiceAccountClient(client);
        if (user != null) {
            user = this.validateAndProxyUser(client.getRealm(), user);
        }
        return user;
    }

    @Override
    public List<UserModel> getUsers(RealmModel realm, boolean includeServiceAccounts) {
        return this.getUsers(realm, 0, 0x7FFFFFFE, includeServiceAccounts);
    }

    @Override
    public int getUsersCount(RealmModel realm) {
        return this.session.userStorage().getUsersCount(realm);
    }

    protected List<UserModel> query(PaginatedQuery pagedQuery, RealmModel realm, int firstResult, int maxResults) {
        int added;
        LinkedList<UserModel> results = new LinkedList<UserModel>();
        if (maxResults == 0) {
            return results;
        }
        int first = firstResult;
        int max = maxResults;
        do {
            List<UserModel> query;
            if ((query = pagedQuery.query(realm, first, max)) == null || query.size() == 0) {
                return results;
            }
            added = 0;
            for (UserModel user : query) {
                if ((user = this.validateAndProxyUser(realm, user)) == null) continue;
                results.add(user);
                ++added;
            }
            if (results.size() == maxResults) {
                return results;
            }
            if (query.size() < max) {
                return results;
            }
            first = query.size();
        } while ((max -= added) > 0);
        return results;
    }

    @Override
    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults, final boolean includeServiceAccounts) {
        return this.query(new PaginatedQuery(){

            @Override
            public List<UserModel> query(RealmModel realm, int first, int max) {
                return UserFederationManager.this.session.userStorage().getUsers(realm, first, max, includeServiceAccounts);
            }
        }, realm, firstResult, maxResults);
    }

    @Override
    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, 0, 0x7FFFFFFE);
    }

    void federationLoad(RealmModel realm, Map<String, String> attributes) {
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            fed.searchByAttributes(attributes, realm, 30);
        }
    }

    @Override
    public List<UserModel> searchForUser(final String search, RealmModel realm, int firstResult, int maxResults) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        int spaceIndex = search.lastIndexOf(32);
        if (spaceIndex > -1) {
            String firstName = search.substring(0, spaceIndex).trim();
            String lastName = search.substring(spaceIndex).trim();
            attributes.put("firstName", firstName);
            attributes.put("lastName", lastName);
        } else if (search.indexOf(64) > -1) {
            attributes.put("username", search.trim().toLowerCase());
            attributes.put("email", search.trim().toLowerCase());
        } else {
            attributes.put("lastName", search.trim());
            attributes.put("username", search.trim().toLowerCase());
        }
        this.federationLoad(realm, attributes);
        return this.query(new PaginatedQuery(){

            @Override
            public List<UserModel> query(RealmModel realm, int first, int max) {
                return UserFederationManager.this.session.userStorage().searchForUser(search, realm, first, max);
            }
        }, realm, firstResult, maxResults);
    }

    @Override
    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        return this.searchForUserByAttributes(attributes, realm, 0, 0x7FFFFFFE);
    }

    @Override
    public List<UserModel> searchForUserByAttributes(final Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        this.federationLoad(realm, attributes);
        return this.query(new PaginatedQuery(){

            @Override
            public List<UserModel> query(RealmModel realm, int first, int max) {
                return UserFederationManager.this.session.userStorage().searchForUserByAttributes(attributes, realm, first, max);
            }
        }, realm, firstResult, maxResults);
    }

    @Override
    public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
        return this.session.userStorage().searchForUserByUserAttribute(attrName, attrValue, realm);
    }

    @Override
    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel user, RealmModel realm) {
        this.validateUser(realm, user);
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        return this.session.userStorage().getFederatedIdentities(user, realm);
    }

    @Override
    public FederatedIdentityModel getFederatedIdentity(UserModel user, String socialProvider, RealmModel realm) {
        this.validateUser(realm, user);
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        return this.session.userStorage().getFederatedIdentity(user, socialProvider, realm);
    }

    @Override
    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        this.session.userStorage().grantToAllUsers(realm, role);
    }

    @Override
    public void preRemove(RealmModel realm) {
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            fed.preRemove(realm);
        }
        this.session.userStorage().preRemove(realm);
    }

    @Override
    public void preRemove(RealmModel realm, UserFederationProviderModel model) {
        this.session.userStorage().preRemove(realm, model);
    }

    @Override
    public void preRemove(RealmModel realm, GroupModel group) {
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            fed.preRemove(realm, group);
        }
        this.session.userStorage().preRemove(realm, group);
    }

    @Override
    public void preRemove(RealmModel realm, RoleModel role) {
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            fed.preRemove(realm, role);
        }
        this.session.userStorage().preRemove(realm, role);
    }

    @Override
    public void preRemove(RealmModel realm, ClientModel client) {
        this.session.userStorage().preRemove(realm, client);
    }

    @Override
    public void preRemove(ProtocolMapperModel protocolMapper) {
        this.session.userStorage().preRemove(protocolMapper);
    }

    public void updateCredential(RealmModel realm, UserModel user, UserCredentialModel credential) {
        PasswordPolicy.Error error;
        if (credential.getType().equals("password") && realm.getPasswordPolicy() != null && (error = realm.getPasswordPolicy().validate(this.session, user, credential.getValue())) != null) {
            throw new ModelException(error.getMessage(), error.getParameters());
        }
        user.updateCredential(credential);
    }

    @Override
    public boolean validCredentials(KeycloakSession session, RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        UserFederationProvider link = this.getFederationLink(realm, user);
        if (link != null) {
            this.validateUser(realm, user);
            Set<String> supportedCredentialTypes = link.getSupportedCredentialTypes(user);
            if (supportedCredentialTypes.size() > 0) {
                ArrayList<UserCredentialModel> fedCreds = new ArrayList<UserCredentialModel>();
                ArrayList<UserCredentialModel> localCreds = new ArrayList<UserCredentialModel>();
                for (UserCredentialModel cred : input) {
                    if (supportedCredentialTypes.contains(cred.getType())) {
                        fedCreds.add(cred);
                        continue;
                    }
                    localCreds.add(cred);
                }
                if (!link.validCredentials(realm, user, fedCreds)) {
                    return false;
                }
                return session.userStorage().validCredentials(session, realm, user, localCreds);
            }
        }
        return session.userStorage().validCredentials(session, realm, user, input);
    }

    public boolean configuredForCredentialType(String type, RealmModel realm, UserModel user) {
        Set<String> supportedCredentialTypes;
        UserFederationProvider link = this.getFederationLink(realm, user);
        if (link != null && (supportedCredentialTypes = link.getSupportedCredentialTypes(user)).contains(type)) {
            return true;
        }
        if (UserCredentialModel.isOtp(type) && !user.isOtpEnabled()) {
            return false;
        }
        List<UserCredentialValueModel> creds = user.getCredentialsDirectly();
        for (UserCredentialValueModel cred : creds) {
            if (!cred.getType().equals(type)) continue;
            if (UserCredentialModel.isOtp(type)) {
                OTPPolicy otpPolicy = realm.getOTPPolicy();
                if (!cred.getAlgorithm().equals(otpPolicy.getAlgorithm()) || cred.getDigits() != otpPolicy.getDigits()) {
                    return false;
                }
                if (type.equals("totp") && cred.getPeriod() != otpPolicy.getPeriod()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean validCredentials(KeycloakSession session, RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return this.validCredentials(session, realm, user, Arrays.asList(input));
    }

    @Override
    public CredentialValidationOutput validCredentials(KeycloakSession session, RealmModel realm, UserCredentialModel ... input) {
        List<UserFederationProviderModel> fedProviderModels = realm.getUserFederationProviders();
        ArrayList<UserFederationProvider> fedProviders = new ArrayList<UserFederationProvider>();
        for (UserFederationProviderModel fedProviderModel : fedProviderModels) {
            fedProviders.add(this.getFederationProvider(fedProviderModel));
        }
        CredentialValidationOutput result = null;
        for (UserCredentialModel cred : input) {
            UserFederationProvider providerSupportingCreds = null;
            for (UserFederationProvider fedProvider : fedProviders) {
                if (!fedProvider.getSupportedCredentialTypes().contains(cred.getType())) continue;
                providerSupportingCreds = fedProvider;
                break;
            }
            if (providerSupportingCreds == null) {
                logger.warn((Object)("Don't have provider supporting credentials of type " + cred.getType()));
                return CredentialValidationOutput.failed();
            }
            logger.debug((Object)("Found provider [" + providerSupportingCreds + "] supporting credentials of type " + cred.getType()));
            CredentialValidationOutput currentResult = providerSupportingCreds.validCredentials(realm, cred);
            result = result == null ? currentResult : result.merge(currentResult);
        }
        return result != null ? result : CredentialValidationOutput.failed();
    }

    @Override
    public void close() {
    }

    static interface PaginatedQuery {
        public List<UserModel> query(RealmModel var1, int var2, int var3);
    }
}

