/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.h2.mvstore.DataUtils;
import org.h2.store.fs.FilePath;

public class MVStoreTool {
    public static void main(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"-dump".equals(stringArray[i])) continue;
            String string = stringArray[++i];
            MVStoreTool.dump(string, new PrintWriter(System.out));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(String string, Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        if (!FilePath.get(string).exists()) {
            printWriter.println("File not found: " + string);
            return;
        }
        FileChannel fileChannel = null;
        int n = 4096;
        try {
            fileChannel = FilePath.get(string).open("r");
            long l = fileChannel.size();
            printWriter.println("file " + string);
            printWriter.println("    length " + l);
            ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
            long l2 = 0L;
            while (l2 < l) {
                byteBuffer.rewind();
                DataUtils.readFully(fileChannel, l2, byteBuffer);
                byteBuffer.rewind();
                byte by = byteBuffer.get();
                if (by == 72) {
                    printWriter.println("    header at " + l2);
                    printWriter.println("    " + new String(byteBuffer.array(), "UTF-8").trim());
                    l2 += (long)n;
                    continue;
                }
                if (by != 99) {
                    l2 += (long)n;
                    continue;
                }
                int n2 = byteBuffer.getInt();
                int n3 = byteBuffer.getInt();
                int n4 = byteBuffer.getInt();
                long l3 = byteBuffer.getLong();
                long l4 = byteBuffer.getLong();
                long l5 = byteBuffer.getLong();
                printWriter.println("    chunk " + n3 + " at " + l2 + " length " + n2 + " pageCount " + n4 + " root " + l3 + " maxLength " + l4 + " maxLengthLive " + l5);
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2);
                DataUtils.readFully(fileChannel, l2, byteBuffer2);
                int n5 = byteBuffer.position();
                l2 = (l2 + (long)n2 + (long)n) / (long)n * (long)n;
                n2 -= n5;
                while (n2 > 0) {
                    byteBuffer2.position(n5);
                    int n6 = byteBuffer2.getInt();
                    byteBuffer2.getShort();
                    long l6 = DataUtils.readVarInt(byteBuffer2);
                    int n7 = DataUtils.readVarInt(byteBuffer2);
                    byte by2 = byteBuffer2.get();
                    boolean bl = (by2 & 2) != 0;
                    boolean bl2 = (by2 & 1) != 0;
                    printWriter.println("        map " + l6 + " at " + n5 + " " + (bl2 ? "node" : "leaf") + " " + (bl ? "compressed " : "") + "len: " + n6 + " entries: " + n7);
                    n5 += n6;
                    n2 -= n6;
                }
            }
        }
        catch (IOException iOException) {
            printWriter.println("ERROR: " + iOException);
            iOException.printStackTrace(printWriter);
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
        printWriter.println();
        printWriter.flush();
    }
}

