/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.remoting.transport.Transport;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.sessions.infinispan.initializer.InitializerState;
import org.keycloak.models.sessions.infinispan.initializer.SessionInitializerWorker;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;
import org.keycloak.models.utils.KeycloakModelUtils;

public class InfinispanUserSessionInitializer {
    private static final String STATE_KEY_PREFIX = "distributed::";
    private static final Logger log = Logger.getLogger(InfinispanUserSessionInitializer.class);
    private final KeycloakSessionFactory sessionFactory;
    private final Cache<String, Serializable> workCache;
    private final SessionLoader sessionLoader;
    private final int maxErrors;
    private final int sessionsPerSegment;
    private final String stateKey;

    public InfinispanUserSessionInitializer(KeycloakSessionFactory sessionFactory, Cache<String, Serializable> workCache, SessionLoader sessionLoader, int maxErrors, int sessionsPerSegment, String stateKeySuffix) {
        this.sessionFactory = sessionFactory;
        this.workCache = workCache;
        this.sessionLoader = sessionLoader;
        this.maxErrors = maxErrors;
        this.sessionsPerSegment = sessionsPerSegment;
        this.stateKey = STATE_KEY_PREFIX + stateKeySuffix;
    }

    public void initCache() {
        this.workCache.getAdvancedCache().getComponentRegistry().registerComponent((Object)this.sessionFactory, KeycloakSessionFactory.class);
    }

    public void loadPersistentSessions() {
        if (this.isFinished()) {
            return;
        }
        while (!this.isFinished()) {
            if (!this.isCoordinator()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    log.error((Object)"Interrupted", (Throwable)ie);
                }
                continue;
            }
            this.startLoading();
        }
    }

    private boolean isFinished() {
        InitializerState state = (InitializerState)this.workCache.get((Object)this.stateKey);
        return state != null && state.isFinished();
    }

    private InitializerState getOrCreateInitializerState() {
        InitializerState state = (InitializerState)this.workCache.get((Object)this.stateKey);
        if (state == null) {
            final int[] count = new int[1];
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    InfinispanUserSessionInitializer.this.sessionLoader.init(session);
                }
            });
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    count[0] = InfinispanUserSessionInitializer.this.sessionLoader.getSessionsCount(session);
                }
            });
            state = new InitializerState();
            state.init(count[0], this.sessionsPerSegment);
            this.saveStateToCache(state);
        }
        return state;
    }

    private void saveStateToCache(final InitializerState state) {
        this.retry(3, new Runnable(){

            @Override
            public void run() {
                InfinispanUserSessionInitializer.this.workCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FORCE_SYNCHRONOUS}).put((Object)InfinispanUserSessionInitializer.this.stateKey, (Object)state);
            }
        });
    }

    private boolean isCoordinator() {
        Transport transport = this.workCache.getCacheManager().getTransport();
        return transport == null || transport.isCoordinator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoading() {
        InitializerState state = this.getOrCreateInitializerState();
        int processors = Runtime.getRuntime().availableProcessors();
        ExecutorService localExecutor = Executors.newCachedThreadPool();
        Transport transport = this.workCache.getCacheManager().getTransport();
        boolean distributed = transport != null;
        ExecutorService executorService = distributed ? new DefaultExecutorService(this.workCache, localExecutor) : localExecutor;
        int errors = 0;
        try {
            while (!state.isFinished()) {
                int nodesCount = transport == null ? 1 : transport.getMembers().size();
                int distributedWorkersCount = processors * nodesCount;
                log.debugf("Starting next iteration with %d workers", distributedWorkersCount);
                List<Integer> segments = state.getUnfinishedSegments(distributedWorkersCount);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("unfinished segments for this iteration: " + segments));
                }
                LinkedList futures = new LinkedList();
                for (Integer n : segments) {
                    SessionInitializerWorker worker = new SessionInitializerWorker();
                    worker.setWorkerEnvironment(n, this.sessionsPerSegment, this.sessionLoader);
                    if (!distributed) {
                        worker.setEnvironment(this.workCache, null);
                    }
                    Future future = executorService.submit(worker);
                    futures.add(future);
                }
                for (Future future : futures) {
                    try {
                        WorkerResult result = (WorkerResult)future.get();
                        if (result.getSuccess().booleanValue()) {
                            int computedSegment = result.getSegment();
                            state.markSegmentFinished(computedSegment);
                            continue;
                        }
                        if (!log.isTraceEnabled()) continue;
                        log.tracef("Segment %d failed to compute", (Object)result.getSegment());
                    }
                    catch (InterruptedException ie) {
                        log.error((Object)("Interruped exception when computed future. Errors: " + ++errors), (Throwable)ie);
                    }
                    catch (ExecutionException ee) {
                        log.error((Object)("ExecutionException when computed future. Errors: " + ++errors), (Throwable)ee);
                    }
                }
                if (errors >= this.maxErrors) {
                    throw new RuntimeException("Maximum count of worker errors occured. Limit was " + this.maxErrors + ". See server.log for details");
                }
                this.saveStateToCache(state);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("New initializer state pushed. The state is: " + state.printState()));
            }
        }
        finally {
            if (distributed) {
                executorService.shutdown();
            }
            localExecutor.shutdown();
        }
    }

    private void retry(int retry, Runnable runnable) {
        while (true) {
            try {
                runnable.run();
                return;
            }
            catch (RuntimeException e) {
                ComponentStatus status = this.workCache.getStatus();
                if (!status.isStopping() && !status.isTerminated()) continue;
                log.warn((Object)"Failed to put initializerState to the cache. Cache is already terminating");
                log.debug((Object)e.getMessage(), (Throwable)e);
                return;
                if (--retry != 0) continue;
                throw e;
            }
            break;
        }
    }

    public static class WorkerResult
    implements Serializable {
        private Integer segment;
        private Boolean success;

        public static WorkerResult create(Integer segment, boolean success) {
            WorkerResult res = new WorkerResult();
            res.setSegment(segment);
            res.setSuccess(success);
            return res;
        }

        public Integer getSegment() {
            return this.segment;
        }

        public void setSegment(Integer segment) {
            this.segment = segment;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }
    }
}

