/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import javax.ws.rs.core.Response;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.clientregistration.ClientRegistrationAuth;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.clientregistration.ClientRegistrationTokenUtils;

public abstract class AbstractClientRegistrationProvider
implements ClientRegistrationProvider {
    protected KeycloakSession session;
    protected EventBuilder event;
    protected ClientRegistrationAuth auth;

    public AbstractClientRegistrationProvider(KeycloakSession session) {
        this.session = session;
    }

    public ClientRepresentation create(ClientRepresentation client) {
        this.event.event(EventType.CLIENT_REGISTER);
        this.auth.requireCreate();
        try {
            ClientModel clientModel = RepresentationToModel.createClient((KeycloakSession)this.session, (RealmModel)this.session.getContext().getRealm(), (ClientRepresentation)client, (boolean)true);
            client = ModelToRepresentation.toRepresentation((ClientModel)clientModel);
            String registrationAccessToken = ClientRegistrationTokenUtils.updateRegistrationAccessToken(this.session, clientModel);
            client.setRegistrationAccessToken(registrationAccessToken);
            if (this.auth.isInitialAccessToken()) {
                ClientInitialAccessModel initialAccessModel = this.auth.getInitialAccessModel();
                initialAccessModel.decreaseRemainingCount();
            }
            this.event.client(client.getClientId()).success();
            return client;
        }
        catch (ModelDuplicateException e) {
            throw new ErrorResponseException("invalid_client_metadata", "Client Identifier in use", Response.Status.BAD_REQUEST);
        }
    }

    public ClientRepresentation get(String clientId) {
        this.event.event(EventType.CLIENT_INFO);
        ClientModel client = this.session.getContext().getRealm().getClientByClientId(clientId);
        this.auth.requireView(client);
        ClientRepresentation rep = ModelToRepresentation.toRepresentation((ClientModel)client);
        if (this.auth.isRegistrationAccessToken()) {
            String registrationAccessToken = ClientRegistrationTokenUtils.updateRegistrationAccessToken(this.session, client);
            rep.setRegistrationAccessToken(registrationAccessToken);
        }
        this.event.client(client.getClientId()).success();
        return rep;
    }

    public ClientRepresentation update(String clientId, ClientRepresentation rep) {
        this.event.event(EventType.CLIENT_UPDATE).client(clientId);
        ClientModel client = this.session.getContext().getRealm().getClientByClientId(clientId);
        this.auth.requireUpdate(client);
        if (!client.getClientId().equals(rep.getClientId())) {
            throw new ErrorResponseException("invalid_client_metadata", "Client Identifier modified", Response.Status.BAD_REQUEST);
        }
        RepresentationToModel.updateClient((ClientRepresentation)rep, (ClientModel)client);
        rep = ModelToRepresentation.toRepresentation((ClientModel)client);
        if (this.auth.isRegistrationAccessToken()) {
            String registrationAccessToken = ClientRegistrationTokenUtils.updateRegistrationAccessToken(this.session, client);
            rep.setRegistrationAccessToken(registrationAccessToken);
        }
        this.event.client(client.getClientId()).success();
        return rep;
    }

    public void delete(String clientId) {
        this.event.event(EventType.CLIENT_DELETE).client(clientId);
        ClientModel client = this.session.getContext().getRealm().getClientByClientId(clientId);
        this.auth.requireUpdate(client);
        if (!this.session.getContext().getRealm().removeClient(client.getId())) {
            throw new ForbiddenException();
        }
        this.event.client(client.getClientId()).success();
    }

    @Override
    public void setAuth(ClientRegistrationAuth auth) {
        this.auth = auth;
    }

    @Override
    public void setEvent(EventBuilder event) {
        this.event = event;
    }

    public void close() {
    }
}

