/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.util.Time;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.clientregistration.ClientRegistrationTokenUtils;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ClientAttributeCertificateResource;
import org.keycloak.services.resources.admin.ProtocolMappersResource;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.ScopeMappedResource;

public class ClientResource {
    protected static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    protected RealmModel realm;
    private RealmAuth auth;
    private AdminEventBuilder adminEvent;
    protected ClientModel client;
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakApplication keycloak;

    protected KeycloakApplication getKeycloakApplication() {
        return this.keycloak;
    }

    public ClientResource(RealmModel realm, RealmAuth auth, ClientModel clientModel, KeycloakSession session, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.auth = auth;
        this.client = clientModel;
        this.session = session;
        this.adminEvent = adminEvent;
        auth.init(RealmAuth.Resource.CLIENT);
    }

    @Path(value="protocol-mappers")
    public ProtocolMappersResource getProtocolMappers() {
        ProtocolMappersResource mappers = new ProtocolMappersResource((ProtocolMapperContainerModel)this.client, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)mappers);
        return mappers;
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response update(ClientRepresentation rep) {
        this.auth.requireManage();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        try {
            ClientResource.updateClientFromRep(rep, this.client, this.session);
            this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(rep).success();
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Client " + rep.getClientId() + " already exists");
        }
    }

    public static void updateClientFromRep(ClientRepresentation rep, ClientModel client, KeycloakSession session) throws ModelDuplicateException {
        if (Boolean.TRUE.equals(rep.isServiceAccountsEnabled()) && !client.isServiceAccountsEnabled()) {
            new ClientManager(new RealmManager(session)).enableServiceAccount(client);
        }
        RepresentationToModel.updateClient((ClientRepresentation)rep, (ClientModel)client);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public ClientRepresentation getClient() {
        this.auth.requireView();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        return ModelToRepresentation.toRepresentation((ClientModel)this.client);
    }

    @Path(value="certificates/{attr}")
    public ClientAttributeCertificateResource getCertficateResource(@PathParam(value="attr") String attributePrefix) {
        return new ClientAttributeCertificateResource(this.realm, this.auth, this.client, this.session, attributePrefix, this.adminEvent);
    }

    @GET
    @NoCache
    @Path(value="installation/providers/{providerId}")
    public Response getInstallationProvider(@PathParam(value="providerId") String providerId) {
        this.auth.requireView();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        ClientInstallationProvider provider = (ClientInstallationProvider)this.session.getProvider(ClientInstallationProvider.class, providerId);
        if (provider == null) {
            throw new NotFoundException("Unknown Provider");
        }
        return provider.generateInstallation(this.session, this.realm, this.client, this.keycloak.getBaseUri(this.uriInfo));
    }

    @DELETE
    @NoCache
    public void deleteClient() {
        this.auth.requireManage();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        new ClientManager(new RealmManager(this.session)).removeClient(this.realm, this.client);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    @Path(value="client-secret")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CredentialRepresentation regenerateSecret() {
        this.auth.requireManage();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        logger.debug("regenerateSecret");
        UserCredentialModel cred = KeycloakModelUtils.generateSecret((ClientModel)this.client);
        CredentialRepresentation rep = ModelToRepresentation.toRepresentation((UserCredentialModel)cred);
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).representation(rep).success();
        return rep;
    }

    @Path(value="registration-access-token")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ClientRepresentation regenerateRegistrationAccessToken() {
        this.auth.requireManage();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        String token = ClientRegistrationTokenUtils.updateRegistrationAccessToken(this.realm, this.uriInfo, this.client);
        ClientRepresentation rep = ModelToRepresentation.toRepresentation((ClientModel)this.client);
        rep.setRegistrationAccessToken(token);
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).representation(rep).success();
        return rep;
    }

    @Path(value="client-secret")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public CredentialRepresentation getClientSecret() {
        this.auth.requireView();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        logger.debug("getClientSecret");
        UserCredentialModel model = UserCredentialModel.secret((String)this.client.getSecret());
        if (model == null) {
            throw new NotFoundException("Client does not have a secret");
        }
        return ModelToRepresentation.toRepresentation((UserCredentialModel)model);
    }

    @Path(value="scope-mappings")
    public ScopeMappedResource getScopeMappedResource() {
        return new ScopeMappedResource(this.realm, this.auth, (ScopeContainerModel)this.client, this.session, this.adminEvent);
    }

    @Path(value="roles")
    public RoleContainerResource getRoleContainerResource() {
        return new RoleContainerResource(this.uriInfo, this.realm, this.auth, (RoleContainerModel)this.client, this.adminEvent);
    }

    @Path(value="service-account-user")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public UserRepresentation getServiceAccountUser() {
        this.auth.requireView();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        UserModel user = this.session.users().getUserByServiceAccountClient(this.client);
        if (user == null) {
            if (this.client.isServiceAccountsEnabled()) {
                new ClientManager(new RealmManager(this.session)).enableServiceAccount(this.client);
                user = this.session.users().getUserByServiceAccountClient(this.client);
            } else {
                throw new BadRequestException("Service account not enabled for the client '" + this.client.getClientId() + "'");
            }
        }
        return ModelToRepresentation.toRepresentation((UserModel)user);
    }

    @Path(value="push-revocation")
    @POST
    @Produces(value={"application/json"})
    public GlobalRequestResult pushRevocation() {
        this.auth.requireManage();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
        return new ResourceAdminManager(this.session).pushClientRevocationPolicy(this.uriInfo.getRequestUri(), this.realm, this.client);
    }

    @Path(value="session-count")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, Long> getApplicationSessionCount() {
        this.auth.requireView();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("count", this.session.sessions().getActiveUserSessions(this.client.getRealm(), this.client));
        return map;
    }

    @Path(value="user-sessions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserSessionRepresentation> getUserSessions(@QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        this.auth.requireView();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : -1;
        ArrayList<UserSessionRepresentation> sessions = new ArrayList<UserSessionRepresentation>();
        for (UserSessionModel userSession : this.session.sessions().getUserSessions(this.client.getRealm(), this.client, firstResult.intValue(), maxResults.intValue())) {
            UserSessionRepresentation rep = ModelToRepresentation.toRepresentation((UserSessionModel)userSession);
            sessions.add(rep);
        }
        return sessions;
    }

    @Path(value="offline-session-count")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, Long> getOfflineSessionCount() {
        this.auth.requireView();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("count", this.session.sessions().getOfflineSessionsCount(this.client.getRealm(), this.client));
        return map;
    }

    @Path(value="offline-sessions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserSessionRepresentation> getOfflineUserSessions(@QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        this.auth.requireView();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : -1;
        ArrayList<UserSessionRepresentation> sessions = new ArrayList<UserSessionRepresentation>();
        List userSessions = this.session.sessions().getOfflineUserSessions(this.client.getRealm(), this.client, firstResult.intValue(), maxResults.intValue());
        for (UserSessionModel userSession : userSessions) {
            UserSessionRepresentation rep = ModelToRepresentation.toRepresentation((UserSessionModel)userSession);
            for (ClientSessionModel clientSession : userSession.getClientSessions()) {
                if (!this.client.getId().equals(clientSession.getClient().getId())) continue;
                rep.setLastAccess(Time.toMillis((int)clientSession.getTimestamp()));
                break;
            }
            sessions.add(rep);
        }
        return sessions;
    }

    @Path(value="nodes")
    @POST
    @Consumes(value={"application/json"})
    public void registerNode(Map<String, String> formParams) {
        this.auth.requireManage();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        String node = formParams.get("node");
        if (node == null) {
            throw new BadRequestException("Node not found in params");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Register node: " + node);
        }
        this.client.registerNode(node, Time.currentTime());
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
    }

    @Path(value="nodes/{node}")
    @DELETE
    @NoCache
    public void unregisterNode(@PathParam(value="node") String node) {
        Integer time;
        this.auth.requireManage();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Unregister node: " + node);
        }
        if ((time = (Integer)this.client.getRegisteredNodes().get(node)) == null) {
            throw new NotFoundException("Client does not have node ");
        }
        this.client.unregisterNode(node);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    @Path(value="test-nodes-available")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public GlobalRequestResult testNodesAvailable() {
        this.auth.requireManage();
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        logger.debug("Test availability of cluster nodes");
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.uriInfo).success();
        return new ResourceAdminManager(this.session).testNodesAvailability(this.uriInfo.getRequestUri(), this.realm, this.client);
    }
}

