/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.keycloak.federation.ldap.LDAPConfig;
import org.keycloak.models.UserFederationMapperModel;

public class LDAPMappersComparator {
    public static List<UserFederationMapperModel> sortAsc(LDAPConfig ldapConfig, Collection<UserFederationMapperModel> mappers) {
        ImportantFirstComparator comparator = new ImportantFirstComparator(ldapConfig);
        ArrayList<UserFederationMapperModel> result = new ArrayList<UserFederationMapperModel>(mappers);
        Collections.sort(result, comparator);
        return result;
    }

    public static List<UserFederationMapperModel> sortDesc(LDAPConfig ldapConfig, Collection<UserFederationMapperModel> mappers) {
        Comparator comparator = new ImportantFirstComparator(ldapConfig).reversed();
        ArrayList<UserFederationMapperModel> result = new ArrayList<UserFederationMapperModel>(mappers);
        Collections.sort(result, comparator);
        return result;
    }

    private static class ImportantFirstComparator
    implements Comparator<UserFederationMapperModel> {
        private final LDAPConfig ldapConfig;

        public ImportantFirstComparator(LDAPConfig ldapConfig) {
            this.ldapConfig = ldapConfig;
        }

        @Override
        public int compare(UserFederationMapperModel o1, UserFederationMapperModel o2) {
            boolean isO2LdapAttr;
            boolean isO2UsernameMapper;
            boolean isO1AttrMapper = o1.getFederationMapperType().equals("user-attribute-ldap-mapper");
            boolean isO2AttrMapper = o2.getFederationMapperType().equals("user-attribute-ldap-mapper");
            if (!isO1AttrMapper) {
                if (isO2AttrMapper) {
                    return 1;
                }
                return 0;
            }
            if (!isO2AttrMapper) {
                return -1;
            }
            String model1 = (String)o1.getConfig().get("user.model.attribute");
            String model2 = (String)o2.getConfig().get("user.model.attribute");
            boolean isO1UsernameMapper = model1 != null && model1.equalsIgnoreCase("username");
            boolean bl = isO2UsernameMapper = model2 != null && model2.equalsIgnoreCase("username");
            if (!isO1UsernameMapper) {
                if (isO2UsernameMapper) {
                    return 1;
                }
                return 0;
            }
            if (!isO2UsernameMapper) {
                return -1;
            }
            String o1LdapAttr = (String)o1.getConfig().get("ldap.attribute");
            String o2LdapAttr = (String)o2.getConfig().get("ldap.attribute");
            boolean isO1LdapAttr = o1LdapAttr != null && this.ldapConfig.getUsernameLdapAttribute().equalsIgnoreCase(o1LdapAttr);
            boolean bl2 = isO2LdapAttr = o2LdapAttr != null && this.ldapConfig.getUsernameLdapAttribute().equalsIgnoreCase(o2LdapAttr);
            if (!isO1LdapAttr) {
                if (isO2LdapAttr) {
                    return 1;
                }
                return 0;
            }
            if (!isO2LdapAttr) {
                return -1;
            }
            return 0;
        }
    }
}

