/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.nio;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import org.jgroups.util.Util;

public class Buffers {
    protected final ByteBuffer[] bufs;

    public Buffers() {
        this(null);
    }

    public Buffers(int capacity) {
        this.bufs = new ByteBuffer[capacity * 2];
    }

    public Buffers(ByteBuffer data) {
        this.bufs = new ByteBuffer[]{ByteBuffer.allocate(4), data};
    }

    public int remaining() {
        return this.bufs[0].remaining() + (this.bufs[1] != null ? this.bufs[1].remaining() : 0);
    }

    public boolean write(SocketChannel ch, ByteBuffer buf) throws Exception {
        if (this.bufs[1] != null && !this.write(ch)) {
            return false;
        }
        this.bufs[0].clear();
        this.bufs[0].putInt(buf.remaining()).flip();
        this.bufs[1] = buf;
        return this.write(ch);
    }

    public boolean write(SocketChannel ch) throws Exception {
        if (this.bufs[1] == null) {
            return true;
        }
        if (ch != null) {
            try {
                ch.write(this.bufs);
            }
            catch (ClosedChannelException closed_ex) {
                throw closed_ex;
            }
            catch (IOException | NotYetConnectedException exception) {
                // empty catch block
            }
        }
        return this.nullData(this.remaining() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer read(SocketChannel ch) throws Exception {
        if (this.bufs[0].hasRemaining() && ch.read(this.bufs[0]) < 0) {
            throw new EOFException();
        }
        if (this.bufs[0].hasRemaining()) {
            return null;
        }
        if (this.bufs[1] == null) {
            int len = this.bufs[0].getInt(0);
            this.bufs[1] = ByteBuffer.allocate(len);
        }
        if (this.bufs[1].hasRemaining() && ch.read(this.bufs[1]) < 0) {
            throw new EOFException();
        }
        if (!this.bufs[1].hasRemaining()) {
            try {
                ByteBuffer byteBuffer = (ByteBuffer)this.bufs[1].clear();
                return byteBuffer;
            }
            finally {
                this.bufs[0].clear();
                this.bufs[1] = null;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(Util.print(this.bufs[0]));
        if (this.bufs[1] != null) {
            sb.append(", ").append(Util.print(this.bufs[1]));
        }
        sb.append(", rem ").append(this.remaining());
        return sb.toString();
    }

    protected boolean nullData(boolean all_data_sent) {
        if (all_data_sent) {
            this.bufs[1] = null;
        }
        return all_data_sent;
    }
}

