/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import java.net.URI;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.protocol.StatusCodeType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusDetailType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;
import org.w3c.dom.Element;

public abstract class SAMLStatusResponseTypeParser {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    protected StatusResponseType parseBaseAttributes(StartElement startElement) throws ParsingException {
        Attribute inResponseTo;
        Attribute consent;
        Attribute idAttr = startElement.getAttributeByName(new QName(JBossSAMLConstants.ID.get()));
        if (idAttr == null) {
            throw logger.parserRequiredAttribute("ID");
        }
        String id = StaxParserUtil.getAttributeValue((Attribute)idAttr);
        Attribute version = startElement.getAttributeByName(new QName(JBossSAMLConstants.VERSION.get()));
        if (version == null) {
            throw logger.parserRequiredAttribute("Version");
        }
        StringUtil.match((String)JBossSAMLConstants.VERSION_2_0.get(), (String)StaxParserUtil.getAttributeValue((Attribute)version));
        Attribute issueInstant = startElement.getAttributeByName(new QName(JBossSAMLConstants.ISSUE_INSTANT.get()));
        if (issueInstant == null) {
            throw logger.parserRequiredAttribute("IssueInstant");
        }
        XMLGregorianCalendar issueInstantVal = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue((Attribute)issueInstant));
        StatusResponseType response = new StatusResponseType(id, issueInstantVal);
        Attribute destination = startElement.getAttributeByName(new QName(JBossSAMLConstants.DESTINATION.get()));
        if (destination != null) {
            response.setDestination(StaxParserUtil.getAttributeValue((Attribute)destination));
        }
        if ((consent = startElement.getAttributeByName(new QName(JBossSAMLConstants.CONSENT.get()))) != null) {
            response.setConsent(StaxParserUtil.getAttributeValue((Attribute)consent));
        }
        if ((inResponseTo = startElement.getAttributeByName(new QName(JBossSAMLConstants.IN_RESPONSE_TO.get()))) != null) {
            response.setInResponseTo(StaxParserUtil.getAttributeValue((Attribute)inResponseTo));
        }
        return response;
    }

    protected StatusType parseStatus(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        String STATUS = JBossSAMLConstants.STATUS.get();
        StaxParserUtil.validate((StartElement)startElement, (String)STATUS);
        StatusType status = new StatusType();
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader)) != null) {
            XMLEvent xmlEvent;
            EndElement endElement;
            QName startElementName = startElement.getName();
            String elementTag = startElementName.getLocalPart();
            StatusCodeType statusCode = new StatusCodeType();
            if (JBossSAMLConstants.STATUS_CODE.get().equals(elementTag)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                if (startElement == null) break;
                Attribute valueAttr = startElement.getAttributeByName(new QName("Value"));
                if (valueAttr != null) {
                    statusCode.setValue(URI.create(StaxParserUtil.getAttributeValue((Attribute)valueAttr)));
                }
                status.setStatusCode(statusCode);
                startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
                if (startElement == null) {
                    endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    if (endElement == null) continue;
                    StaxParserUtil.validate((EndElement)endElement, (String)JBossSAMLConstants.STATUS_CODE.get());
                    continue;
                }
                elementTag = startElement.getName().getLocalPart();
                if (JBossSAMLConstants.STATUS_CODE.get().equals(elementTag)) {
                    StatusCodeType subStatusCodeType = new StatusCodeType();
                    startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                    Attribute subValueAttr = startElement.getAttributeByName(new QName("Value"));
                    if (subValueAttr != null) {
                        subStatusCodeType.setValue(URI.create(StaxParserUtil.getAttributeValue((Attribute)subValueAttr)));
                    }
                    statusCode.setStatusCode(subStatusCodeType);
                    EndElement endElement2 = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    StaxParserUtil.validate((EndElement)endElement2, (String)JBossSAMLConstants.STATUS_CODE.get());
                    continue;
                }
            }
            if (JBossSAMLConstants.STATUS_MESSAGE.get().equals(elementTag)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                if (startElement == null) break;
                status.setStatusMessage(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader));
            }
            if (JBossSAMLConstants.STATUS_DETAIL.get().equals(elementTag)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                if (startElement == null) break;
                Element domElement = StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader);
                StatusDetailType statusDetailType = new StatusDetailType();
                statusDetailType.addStatusDetail(domElement);
                status.setStatusDetail(statusDetailType);
            }
            if (!((xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) instanceof EndElement) || StaxParserUtil.matches((EndElement)(endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader)), (String)STATUS)) break;
            throw logger.parserUnknownEndElement(StaxParserUtil.getEndElementName((EndElement)endElement));
        }
        return status;
    }
}

