/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import java.util.Properties;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobExecutionException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.batch.jberet.BatchResourceDescriptionResolver;
import org.wildfly.extension.batch.jberet.BatchSubsystemDefinition;
import org.wildfly.extension.batch.jberet.deployment.JobOperationStepHandler;

public class BatchDeploymentResourceDefinition
extends SimpleResourceDefinition {
    private static final ResourceDescriptionResolver DEFAULT_RESOLVER = BatchResourceDescriptionResolver.getResourceDescriptionResolver("deployment");
    private static final SimpleAttributeDefinition EXECUTION_ID = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"execution-id", (ModelType)ModelType.LONG, (boolean)false).setValidator((ParameterValidator)new LongRangeValidator(1L, false))).build();
    private static final SimpleAttributeDefinition JOB_XML_NAME = SimpleAttributeDefinitionBuilder.create((String)"job-xml-name", (ModelType)ModelType.STRING, (boolean)false).build();
    private static final SimpleMapAttributeDefinition PROPERTIES = new SimpleMapAttributeDefinition.Builder("properties", ModelType.STRING, true).build();
    private static final SimpleOperationDefinition START_JOB = new SimpleOperationDefinitionBuilder("start-job", DEFAULT_RESOLVER).setParameters(new AttributeDefinition[]{JOB_XML_NAME, PROPERTIES}).setReplyType(ModelType.LONG).setRuntimeOnly().build();
    private static final SimpleOperationDefinition RESTART_JOB = new SimpleOperationDefinitionBuilder("restart-job", DEFAULT_RESOLVER).setParameters(new AttributeDefinition[]{EXECUTION_ID, PROPERTIES}).setReplyType(ModelType.LONG).setRuntimeOnly().build();
    private static final SimpleOperationDefinition STOP_JOB = new SimpleOperationDefinitionBuilder("stop-job", DEFAULT_RESOLVER).setParameters(new AttributeDefinition[]{EXECUTION_ID}).setRuntimeOnly().build();

    public BatchDeploymentResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(BatchSubsystemDefinition.SUBSYSTEM_PATH, DEFAULT_RESOLVER).setRuntime());
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)START_JOB, (OperationStepHandler)new JobOperationStepHandler(){

            @Override
            protected void execute(OperationContext context, ModelNode operation, JobOperator jobOperator) throws OperationFailedException {
                String jobName = 1.resolveValue(context, operation, (AttributeDefinition)JOB_XML_NAME).asString();
                Properties properties = 1.resolvePropertyValue(context, operation, (AttributeDefinition)PROPERTIES);
                try {
                    long executionId = jobOperator.start(jobName, properties);
                    context.getResult().set(executionId);
                }
                catch (JobSecurityException | JobStartException e) {
                    throw 1.createOperationFailure(e);
                }
            }
        });
        resourceRegistration.registerOperationHandler((OperationDefinition)STOP_JOB, (OperationStepHandler)new JobOperationStepHandler(){

            @Override
            protected void execute(OperationContext context, ModelNode operation, JobOperator jobOperator) throws OperationFailedException {
                long executionId = 2.resolveValue(context, operation, (AttributeDefinition)EXECUTION_ID).asLong();
                try {
                    jobOperator.stop(executionId);
                }
                catch (JobExecutionNotRunningException | JobSecurityException | NoSuchJobExecutionException e) {
                    throw 2.createOperationFailure(e);
                }
            }
        });
        resourceRegistration.registerOperationHandler((OperationDefinition)RESTART_JOB, (OperationStepHandler)new JobOperationStepHandler(){

            @Override
            protected void execute(OperationContext context, ModelNode operation, JobOperator jobOperator) throws OperationFailedException {
                long executionId = 3.resolveValue(context, operation, (AttributeDefinition)EXECUTION_ID).asLong();
                Properties properties = 3.resolvePropertyValue(context, operation, (AttributeDefinition)PROPERTIES);
                try {
                    long newExecutionId = jobOperator.restart(executionId, properties);
                    context.getResult().set(newExecutionId);
                }
                catch (JobExecutionAlreadyCompleteException | JobExecutionNotMostRecentException | JobRestartException | JobSecurityException | NoSuchJobExecutionException e) {
                    throw 3.createOperationFailure(e);
                }
            }
        });
    }
}

