/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.codec;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.cryptacular.codec.Decoder;

public abstract class AbstractBaseNDecoder
implements Decoder {
    private final char[] block = new char[this.getBlockLength() / this.getBitsPerChar()];
    private final byte[] table;
    private int blockPos;

    public AbstractBaseNDecoder(byte[] decodingTable) {
        this.table = decodingTable;
    }

    @Override
    public void decode(CharBuffer input, ByteBuffer output) {
        while (input.hasRemaining()) {
            char current = input.get();
            if (Character.isWhitespace(current)) continue;
            this.block[this.blockPos++] = current;
            if (this.blockPos != this.block.length) continue;
            this.writeOutput(output);
        }
    }

    @Override
    public void finalize(ByteBuffer output) {
        if (this.blockPos > 0) {
            this.writeOutput(output);
        }
    }

    @Override
    public int outputSize(int inputSize) {
        return inputSize * this.getBitsPerChar() / 8;
    }

    protected abstract int getBlockLength();

    protected abstract int getBitsPerChar();

    private void writeOutput(ByteBuffer output) {
        long value = 0L;
        int shift = this.getBlockLength();
        for (char c : this.block) {
            if (c == '=') break;
            long b = this.table[c & 0x7F];
            if (b < 0L) {
                throw new IllegalArgumentException("Invalid character " + c);
            }
            value |= b << (shift -= this.getBitsPerChar());
        }
        int stop = shift + this.getBitsPerChar() - 1;
        int offset = this.getBlockLength();
        while (offset > stop) {
            output.put((byte)((value & 255L << (offset -= 8)) >> offset));
        }
        this.blockPos = 0;
    }
}

