/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.UserFederationManager;
import org.keycloak.models.UserProvider;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.CacheUserProvider;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.services.DefaultKeycloakContext;
import org.keycloak.services.DefaultKeycloakSessionFactory;
import org.keycloak.services.DefaultKeycloakTransactionManager;

public class DefaultKeycloakSession
implements KeycloakSession {
    private final DefaultKeycloakSessionFactory factory;
    private final Map<Integer, Provider> providers = new HashMap<Integer, Provider>();
    private final List<Provider> closable = new LinkedList<Provider>();
    private final DefaultKeycloakTransactionManager transactionManager;
    private RealmProvider model;
    private UserProvider userModel;
    private UserSessionProvider sessionProvider;
    private UserFederationManager federationManager;
    private KeycloakContext context;

    public DefaultKeycloakSession(DefaultKeycloakSessionFactory factory) {
        this.factory = factory;
        this.transactionManager = new DefaultKeycloakTransactionManager();
        this.federationManager = new UserFederationManager((KeycloakSession)this);
        this.context = new DefaultKeycloakContext(this);
    }

    public KeycloakContext getContext() {
        return this.context;
    }

    private RealmProvider getRealmProvider() {
        CacheRealmProvider cache = this.getProvider(CacheRealmProvider.class);
        if (cache != null) {
            return cache;
        }
        return this.getProvider(RealmProvider.class);
    }

    private UserProvider getUserProvider() {
        CacheUserProvider cache = this.getProvider(CacheUserProvider.class);
        if (cache != null) {
            return cache;
        }
        return this.getProvider(UserProvider.class);
    }

    public void enlistForClose(Provider provider) {
        this.closable.add(provider);
    }

    public KeycloakTransactionManager getTransaction() {
        return this.transactionManager;
    }

    public KeycloakSessionFactory getKeycloakSessionFactory() {
        return this.factory;
    }

    public UserProvider userStorage() {
        if (this.userModel == null) {
            this.userModel = this.getUserProvider();
        }
        return this.userModel;
    }

    public <T extends Provider> T getProvider(Class<T> clazz) {
        ProviderFactory<T> providerFactory;
        Integer hash = clazz.hashCode();
        Provider provider = this.providers.get(hash);
        if (provider == null && (providerFactory = this.factory.getProviderFactory(clazz)) != null) {
            provider = providerFactory.create((KeycloakSession)this);
            this.providers.put(hash, provider);
        }
        return (T)provider;
    }

    public <T extends Provider> T getProvider(Class<T> clazz, String id) {
        ProviderFactory<T> providerFactory;
        Integer hash = clazz.hashCode() + id.hashCode();
        Provider provider = this.providers.get(hash);
        if (provider == null && (providerFactory = this.factory.getProviderFactory(clazz, id)) != null) {
            provider = providerFactory.create((KeycloakSession)this);
            this.providers.put(hash, provider);
        }
        return (T)provider;
    }

    public <T extends Provider> Set<String> listProviderIds(Class<T> clazz) {
        return this.factory.getAllProviderIds(clazz);
    }

    public <T extends Provider> Set<T> getAllProviders(Class<T> clazz) {
        HashSet<T> providers = new HashSet<T>();
        for (String id : this.listProviderIds(clazz)) {
            providers.add(this.getProvider(clazz, id));
        }
        return providers;
    }

    public RealmProvider realms() {
        if (this.model == null) {
            this.model = this.getRealmProvider();
        }
        return this.model;
    }

    public UserFederationManager users() {
        return this.federationManager;
    }

    public UserSessionProvider sessions() {
        if (this.sessionProvider == null) {
            this.sessionProvider = this.getProvider(UserSessionProvider.class);
        }
        return this.sessionProvider;
    }

    public void close() {
        for (Provider p : this.providers.values()) {
            try {
                p.close();
            }
            catch (Exception exception) {}
        }
        for (Provider p : this.closable) {
            try {
                p.close();
            }
            catch (Exception exception) {}
        }
    }
}

