/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;

public class MessageDestinationInjectionSource
extends InjectionSource {
    private final String bindingName;
    private final String messageDestinationName;
    private volatile String resolvedLookupName;
    private volatile String error = null;

    public MessageDestinationInjectionSource(String messageDestinationName, String bindingName) {
        this.messageDestinationName = messageDestinationName;
        this.bindingName = bindingName;
    }

    @Override
    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        if (this.error != null) {
            throw new DeploymentUnitProcessingException(this.error);
        }
        String applicationName = resolutionContext.getApplicationName();
        String moduleName = resolutionContext.getModuleName();
        String componentName = resolutionContext.getComponentName();
        boolean compUsesModule = resolutionContext.isCompUsesModule();
        String lookupName = !this.resolvedLookupName.contains(":") ? (componentName != null && !compUsesModule ? "java:comp/env/" + this.resolvedLookupName : (compUsesModule ? "java:module/env/" + this.resolvedLookupName : "java:jboss/env" + this.resolvedLookupName)) : (this.resolvedLookupName.startsWith("java:comp/") && compUsesModule ? "java:module/" + this.resolvedLookupName.substring(10) : this.resolvedLookupName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)applicationName, (String)moduleName, (String)componentName, (String)lookupName);
        if (lookupName.startsWith("java:")) {
            serviceBuilder.addDependency(bindInfo.getBinderServiceName(), ManagedReferenceFactory.class, injector);
        }
    }

    public void resolve(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ResourceRoot deploymentRoot;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        Set<String> names = applicationDescription.resolveMessageDestination(this.messageDestinationName, (deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT)).getRoot());
        if (names.isEmpty()) {
            this.error = EeLogger.ROOT_LOGGER.noMessageDestination(this.messageDestinationName, this.bindingName);
            return;
        }
        if (names.size() > 1) {
            this.error = EeLogger.ROOT_LOGGER.moreThanOneMessageDestination(this.messageDestinationName, this.bindingName, names);
            return;
        }
        this.resolvedLookupName = names.iterator().next();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageDestinationInjectionSource)) {
            return false;
        }
        if (this.error != null) {
            throw new RuntimeException(this.error);
        }
        if (this.resolvedLookupName == null) {
            throw new RuntimeException("Error equals() cannot be called before resolve()");
        }
        MessageDestinationInjectionSource other = (MessageDestinationInjectionSource)o;
        return MessageDestinationInjectionSource.eq(this.resolvedLookupName, other.resolvedLookupName);
    }

    public int hashCode() {
        return this.messageDestinationName.hashCode();
    }

    private static boolean eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

