/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization;

import org.keycloak.authorization.model.CachedModel;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheSession;
import org.keycloak.models.cache.infinispan.authorization.entities.CachedScope;

public class ScopeAdapter
implements Scope,
CachedModel<Scope> {
    protected CachedScope cached;
    protected StoreFactoryCacheSession cacheSession;
    protected Scope updated;
    protected boolean invalidated;

    public ScopeAdapter(CachedScope cached, StoreFactoryCacheSession cacheSession) {
        this.cached = cached;
        this.cacheSession = cacheSession;
    }

    public Scope getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerScopeInvalidation(this.cached.getId(), this.cached.getName(), this.cached.getResourceServerId());
            this.updated = this.cacheSession.getScopeStoreDelegate().findById(this.cached.getId(), this.cached.getResourceServerId());
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
        return this.updated;
    }

    protected void invalidateFlag() {
        this.invalidated = true;
    }

    public void invalidate() {
        this.invalidated = true;
        this.getDelegateForUpdate();
    }

    public long getCacheTimestamp() {
        return this.cached.getCacheTimestamp();
    }

    protected boolean isUpdated() {
        if (this.updated != null) {
            return true;
        }
        if (!this.invalidated) {
            return false;
        }
        this.updated = this.cacheSession.getScopeStoreDelegate().findById(this.cached.getId(), this.cached.getResourceServerId());
        if (this.updated == null) {
            throw new IllegalStateException("Not found in database");
        }
        return true;
    }

    public String getId() {
        if (this.isUpdated()) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public String getName() {
        if (this.isUpdated()) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.updated.setName(name);
    }

    public String getDisplayName() {
        if (this.isUpdated()) {
            return this.updated.getDisplayName();
        }
        return this.cached.getDisplayName();
    }

    public void setDisplayName(String name) {
        this.getDelegateForUpdate();
        this.updated.setDisplayName(name);
    }

    public String getIconUri() {
        if (this.isUpdated()) {
            return this.updated.getIconUri();
        }
        return this.cached.getIconUri();
    }

    public void setIconUri(String iconUri) {
        this.getDelegateForUpdate();
        this.updated.setIconUri(iconUri);
    }

    public ResourceServer getResourceServer() {
        return this.cacheSession.getResourceServerStore().findById(this.cached.getResourceServerId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Scope)) {
            return false;
        }
        Scope that = (Scope)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

