/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;

public class SimpleClusteredVersionGenerator
implements VersionGenerator {
    private volatile int topologyId = -1;
    private static final SimpleClusteredVersion NON_EXISTING = new SimpleClusteredVersion(0, 0L);
    @Inject
    private CacheNotifier<?, ?> cacheNotifier;

    @Start(priority=11)
    public void start() {
        this.cacheNotifier.addListener(new TopologyIdUpdater());
    }

    @Override
    public IncrementableEntryVersion generateNew() {
        if (this.topologyId == -1) {
            throw new IllegalStateException("Topology id not set yet");
        }
        return new SimpleClusteredVersion(this.topologyId, 1L);
    }

    @Override
    public IncrementableEntryVersion increment(IncrementableEntryVersion initialVersion) {
        if (initialVersion instanceof SimpleClusteredVersion) {
            SimpleClusteredVersion old = (SimpleClusteredVersion)initialVersion;
            return new SimpleClusteredVersion(this.topologyId, old.version + 1L);
        }
        throw new IllegalArgumentException("I only know how to deal with SimpleClusteredVersions, not " + initialVersion.getClass().getName());
    }

    @Override
    public IncrementableEntryVersion nonExistingVersion() {
        return NON_EXISTING;
    }

    @Listener
    public class TopologyIdUpdater {
        @TopologyChanged
        public void onTopologyChange(TopologyChangedEvent<?, ?> tce) {
            SimpleClusteredVersionGenerator.this.topologyId = tce.getNewTopologyId();
        }
    }
}

