/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.LinkedList;
import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo8_0_2
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("8.0.2");
    private static final Logger LOG = Logger.getLogger(MigrateTo8_0_2.class);

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        session.realms().getRealms().forEach(this::migrateAuthenticationFlowsWithAlternativeRequirements);
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateAuthenticationFlowsWithAlternativeRequirements(realm);
    }

    protected void migrateAuthenticationFlowsWithAlternativeRequirements(RealmModel realm) {
        for (AuthenticationFlowModel flow : realm.getAuthenticationFlows()) {
            boolean alternativeFound = false;
            boolean requiredFound = false;
            for (AuthenticationExecutionModel execution : realm.getAuthenticationExecutions(flow.getId())) {
                switch (execution.getRequirement()) {
                    case REQUIRED: 
                    case CONDITIONAL: {
                        requiredFound = true;
                        break;
                    }
                    case ALTERNATIVE: {
                        alternativeFound = true;
                    }
                }
            }
            if (!requiredFound || !alternativeFound) continue;
            int suffix = 0;
            LinkedList<AuthenticationExecutionModel> alternativesToMigrate = new LinkedList<AuthenticationExecutionModel>();
            for (AuthenticationExecutionModel execution : realm.getAuthenticationExecutions(flow.getId())) {
                if (AuthenticationExecutionModel.Requirement.ALTERNATIVE.equals((Object)execution.getRequirement())) {
                    alternativesToMigrate.add(execution);
                }
                if (!AuthenticationExecutionModel.Requirement.REQUIRED.equals((Object)execution.getRequirement()) && !AuthenticationExecutionModel.Requirement.CONDITIONAL.equals((Object)execution.getRequirement()) || alternativesToMigrate.isEmpty()) continue;
                this.migrateAlternatives(realm, flow, alternativesToMigrate, suffix);
                ++suffix;
                alternativesToMigrate.clear();
            }
            if (alternativesToMigrate.isEmpty()) continue;
            this.migrateAlternatives(realm, flow, alternativesToMigrate, suffix);
        }
    }

    private void migrateAlternatives(RealmModel realm, AuthenticationFlowModel parentFlow, LinkedList<AuthenticationExecutionModel> alternativesToMigrate, int suffix) {
        LOG.debugf("Migrating %d ALTERNATIVE executions in the flow '%s' of realm '%s' to separate subflow", alternativesToMigrate.size(), (Object)parentFlow.getAlias(), (Object)realm.getName());
        AuthenticationFlowModel newFlow = new AuthenticationFlowModel();
        newFlow.setTopLevel(false);
        newFlow.setBuiltIn(parentFlow.isBuiltIn());
        newFlow.setAlias(parentFlow.getAlias() + " - Alternatives - " + suffix);
        newFlow.setDescription("Subflow of " + parentFlow.getAlias() + " with alternative executions");
        newFlow.setProviderId("basic-flow");
        newFlow = realm.addAuthenticationFlow(newFlow);
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(parentFlow.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
        execution.setFlowId(newFlow.getId());
        execution.setPriority(alternativesToMigrate.getFirst().getPriority());
        execution.setAuthenticatorFlow(true);
        realm.addAuthenticatorExecution(execution);
        int priority = 0;
        for (AuthenticationExecutionModel ex : alternativesToMigrate) {
            ex.setParentFlow(newFlow.getId());
            ex.setPriority(priority += 10);
            realm.updateAuthenticatorExecution(ex);
        }
    }
}

