/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import com.webauthn4j.WebAuthnManager;
import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.authenticator.AuthenticatorImpl;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.util.exception.WebAuthnException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.Time;
import org.keycloak.credential.AttestationStatementConverter;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialPublicKeyConverter;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.credential.WebAuthnCredentialModelInput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.WebAuthnCredentialModel;
import org.keycloak.models.credential.dto.WebAuthnCredentialData;

public class WebAuthnCredentialProvider
implements CredentialProvider<WebAuthnCredentialModel>,
CredentialInputValidator {
    private static final Logger logger = Logger.getLogger(WebAuthnCredentialProvider.class);
    private KeycloakSession session;
    private CredentialPublicKeyConverter credentialPublicKeyConverter;
    private AttestationStatementConverter attestationStatementConverter;

    public WebAuthnCredentialProvider(KeycloakSession session, ObjectConverter objectConverter) {
        this.session = session;
        if (this.credentialPublicKeyConverter == null) {
            this.credentialPublicKeyConverter = new CredentialPublicKeyConverter(objectConverter);
        }
        if (this.attestationStatementConverter == null) {
            this.attestationStatementConverter = new AttestationStatementConverter(objectConverter);
        }
    }

    private UserCredentialStore getCredentialStore() {
        return this.session.userCredentialManager();
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, WebAuthnCredentialModel credentialModel) {
        if (credentialModel.getCreatedDate() == null) {
            credentialModel.setCreatedDate(Long.valueOf(Time.currentTimeMillis()));
        }
        return this.getCredentialStore().createCredential(realm, user, (CredentialModel)credentialModel);
    }

    public boolean deleteCredential(RealmModel realm, UserModel user, String credentialId) {
        logger.debugv("Delete WebAuthn credential. username = {0}, credentialId = {1}", (Object)user.getUsername(), (Object)credentialId);
        return this.getCredentialStore().removeStoredCredential(realm, user, credentialId);
    }

    public WebAuthnCredentialModel getCredentialFromModel(CredentialModel model) {
        return WebAuthnCredentialModel.createFromCredentialModel((CredentialModel)model);
    }

    public WebAuthnCredentialModel getCredentialModelFromCredentialInput(CredentialInput input, String userLabel) {
        if (!this.supportsCredentialType(input.getType())) {
            return null;
        }
        WebAuthnCredentialModelInput webAuthnModel = (WebAuthnCredentialModelInput)input;
        String aaguid = webAuthnModel.getAttestedCredentialData().getAaguid().toString();
        String credentialId = Base64.encodeBytes((byte[])webAuthnModel.getAttestedCredentialData().getCredentialId());
        String credentialPublicKey = this.credentialPublicKeyConverter.convertToDatabaseColumn(webAuthnModel.getAttestedCredentialData().getCOSEKey());
        long counter = webAuthnModel.getCount();
        String attestationStatementFormat = webAuthnModel.getAttestationStatementFormat();
        WebAuthnCredentialModel model = WebAuthnCredentialModel.create((String)this.getType(), (String)userLabel, (String)aaguid, (String)credentialId, null, (String)credentialPublicKey, (long)counter, (String)attestationStatementFormat);
        model.setId(webAuthnModel.getCredentialDBId());
        return model;
    }

    private WebAuthnCredentialModelInput getCredentialInputFromCredentialModel(CredentialModel credential) {
        WebAuthnCredentialModel webAuthnCredential = this.getCredentialFromModel(credential);
        WebAuthnCredentialData credData = webAuthnCredential.getWebAuthnCredentialData();
        WebAuthnCredentialModelInput auth = new WebAuthnCredentialModelInput(this.getType());
        byte[] credentialId = null;
        try {
            credentialId = Base64.decode((String)credData.getCredentialId());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AAGUID aaguid = new AAGUID(credData.getAaguid());
        COSEKey pubKey = this.credentialPublicKeyConverter.convertToEntityAttribute(credData.getCredentialPublicKey());
        AttestedCredentialData attrCredData = new AttestedCredentialData(aaguid, credentialId, pubKey);
        auth.setAttestedCredentialData(attrCredData);
        long count = credData.getCounter();
        auth.setCount(count);
        auth.setCredentialDBId(credential.getId());
        auth.setAttestationStatementFormat(credData.getAttestationStatementFormat());
        return auth;
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getType().equals(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        if (!this.supportsCredentialType(credentialType)) {
            return false;
        }
        return !this.session.userCredentialManager().getStoredCredentialsByType(realm, user, credentialType).isEmpty();
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!WebAuthnCredentialModelInput.class.isInstance(input)) {
            return false;
        }
        WebAuthnCredentialModelInput context = (WebAuthnCredentialModelInput)WebAuthnCredentialModelInput.class.cast(input);
        List<WebAuthnCredentialModelInput> auths = this.getWebAuthnCredentialModelList(realm, user);
        WebAuthnManager webAuthnManager = WebAuthnManager.createNonStrictWebAuthnManager();
        AuthenticationData authenticationData = null;
        try {
            for (WebAuthnCredentialModelInput auth : auths) {
                byte[] credentialId = auth.getAttestedCredentialData().getCredentialId();
                if (!Arrays.equals(credentialId, context.getAuthenticationRequest().getCredentialId())) continue;
                AuthenticatorImpl authenticator = new AuthenticatorImpl(auth.getAttestedCredentialData(), auth.getAttestationStatement(), auth.getCount());
                authenticationData = webAuthnManager.parse(context.getAuthenticationRequest());
                AuthenticationParameters authenticationParameters = new AuthenticationParameters(context.getAuthenticationParameters().getServerProperty(), (Authenticator)authenticator, context.getAuthenticationParameters().isUserVerificationRequired());
                webAuthnManager.validate(authenticationData, authenticationParameters);
                logger.debugv("response.getAuthenticatorData().getFlags() = {0}", (Object)authenticationData.getAuthenticatorData().getFlags());
                long count = auth.getCount();
                CredentialModel credModel = this.getCredentialStore().getStoredCredentialById(realm, user, auth.getCredentialDBId());
                WebAuthnCredentialModel webAuthnCredModel = this.getCredentialFromModel(credModel);
                webAuthnCredModel.updateCounter(count + 1L);
                this.getCredentialStore().updateCredential(realm, user, (CredentialModel)webAuthnCredModel);
                logger.debugf("Successfully validated WebAuthn credential for user %s", (Object)user.getUsername());
                this.dumpCredentialModel(webAuthnCredModel, auth);
                return true;
            }
        }
        catch (WebAuthnException wae) {
            wae.printStackTrace();
            throw wae;
        }
        return false;
    }

    public String getType() {
        return "webauthn";
    }

    private List<WebAuthnCredentialModelInput> getWebAuthnCredentialModelList(RealmModel realm, UserModel user) {
        List credentialModels = this.session.userCredentialManager().getStoredCredentialsByType(realm, user, this.getType());
        return credentialModels.stream().map(this::getCredentialInputFromCredentialModel).collect(Collectors.toList());
    }

    public void dumpCredentialModel(WebAuthnCredentialModel credential, WebAuthnCredentialModelInput auth) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"  Persisted Credential Info::");
            logger.debug((Object)credential);
            logger.debug((Object)"  Context Credential Info::");
            logger.debug((Object)auth);
        }
    }

    public CredentialTypeMetadata getCredentialTypeMetadata(CredentialTypeMetadataContext metadataContext) {
        return CredentialTypeMetadata.builder().type(this.getType()).category(CredentialTypeMetadata.Category.TWO_FACTOR).displayName("webauthn-display-name").helpText("webauthn-help-text").iconCssClass("kcAuthenticatorWebAuthnClass").createAction("webauthn-register").removeable(true).build(this.session);
    }

    protected KeycloakSession getKeycloakSession() {
        return this.session;
    }
}

