/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import javax.ws.rs.core.UriBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.urls.UrlType;

public class ResolveRelative {
    public static String resolveRelativeUri(KeycloakSession session, String rootUrl, String url) {
        String frontendUrl = session.getContext().getUri(UrlType.FRONTEND).getBaseUri().toString();
        String adminUrl = session.getContext().getUri(UrlType.ADMIN).getBaseUri().toString();
        return ResolveRelative.resolveRelativeUri(frontendUrl, adminUrl, rootUrl, url);
    }

    public static String resolveRelativeUri(String frontendUrl, String adminUrl, String rootUrl, String url) {
        if (url == null || !url.startsWith("/")) {
            return url;
        }
        if (rootUrl != null) {
            return ResolveRelative.resolveRootUrl(frontendUrl, adminUrl, rootUrl) + url;
        }
        return UriBuilder.fromUri((String)frontendUrl).replacePath(url).build(new Object[0]).toString();
    }

    public static String resolveRootUrl(KeycloakSession session, String rootUrl) {
        String frontendUrl = session.getContext().getUri(UrlType.FRONTEND).getBaseUri().toString();
        String adminUrl = session.getContext().getUri(UrlType.ADMIN).getBaseUri().toString();
        return ResolveRelative.resolveRootUrl(frontendUrl, adminUrl, rootUrl);
    }

    public static String resolveRootUrl(String frontendUrl, String adminUrl, String rootUrl) {
        if (rootUrl != null) {
            if (rootUrl.equals("${authBaseUrl}")) {
                rootUrl = frontendUrl;
                if (rootUrl.endsWith("/")) {
                    rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
                }
            } else if (rootUrl.equals("${authAdminUrl}") && (rootUrl = adminUrl).endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
        }
        return rootUrl;
    }
}

