"use strict";

(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-styles", "./ChipButton", "../Tooltip", "@patternfly/react-icons", "../../@patternfly/patternfly/components/Chip/chip.css.js", "../../helpers/GenerateId/GenerateId"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-styles"), require("./ChipButton"), require("../Tooltip"), require("@patternfly/react-icons"), require("../../@patternfly/patternfly/components/Chip/chip.css.js"), require("../../helpers/GenerateId/GenerateId"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.reactStyles, global.ChipButton, global.Tooltip, global.reactIcons, global.chipCss, global.GenerateId);
    global.undefined = mod.exports;
  }
})(void 0, function (exports, _propTypes, _react, _reactStyles, _ChipButton, _Tooltip, _reactIcons, _chipCss, _GenerateId) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.Chip = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _chipCss2 = _interopRequireDefault(_chipCss);

  var _GenerateId2 = _interopRequireDefault(_GenerateId);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _typeof2(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof2 = function _typeof2(obj) {
        return typeof obj;
      };
    } else {
      _typeof2 = function _typeof2(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof2(obj);
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
      _typeof = function _typeof(obj) {
        return _typeof2(obj);
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
      };
    }

    return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  var Chip = exports.Chip = function (_React$Component) {
    _inherits(Chip, _React$Component);

    function Chip(props) {
      var _this;

      _classCallCheck(this, Chip);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(Chip).call(this, props));

      _defineProperty(_assertThisInitialized(_this), "span", React.createRef());

      _defineProperty(_assertThisInitialized(_this), "renderOverflowChip", function () {
        var _this$props = _this.props,
            children = _this$props.children,
            className = _this$props.className,
            onClick = _this$props.onClick;
        var Component = _this.props.component;
        return React.createElement(Component, {
          className: (0, _reactStyles.css)(_chipCss2["default"].chip, _chipCss2["default"].modifiers.overflow, className)
        }, React.createElement(_ChipButton.ChipButton, {
          onClick: onClick
        }, React.createElement("span", {
          className: (0, _reactStyles.css)(_chipCss2["default"].chipText)
        }, children)));
      });

      _defineProperty(_assertThisInitialized(_this), "renderChip", function (randomId) {
        var _this$props2 = _this.props,
            children = _this$props2.children,
            closeBtnAriaLabel = _this$props2.closeBtnAriaLabel,
            tooltipPosition = _this$props2.tooltipPosition,
            className = _this$props2.className,
            onClick = _this$props2.onClick,
            isReadOnly = _this$props2.isReadOnly;
        var Component = _this.props.component;

        if (_this.state.isTooltipVisible) {
          return React.createElement(_Tooltip.Tooltip, {
            position: tooltipPosition,
            content: children
          }, React.createElement(Component, {
            className: (0, _reactStyles.css)(_chipCss2["default"].chip, isReadOnly && _chipCss2["default"].modifiers.readOnly, className)
          }, React.createElement("span", {
            ref: _this.span,
            className: (0, _reactStyles.css)(_chipCss2["default"].chipText),
            id: randomId
          }, children), !isReadOnly && React.createElement(_ChipButton.ChipButton, {
            onClick: onClick,
            ariaLabel: closeBtnAriaLabel,
            id: "remove_".concat(randomId),
            "aria-labelledby": "remove_".concat(randomId, " ").concat(randomId)
          }, React.createElement(_reactIcons.TimesCircleIcon, {
            "aria-hidden": "true"
          }))));
        }

        return React.createElement(Component, {
          className: (0, _reactStyles.css)(_chipCss2["default"].chip, isReadOnly && _chipCss2["default"].modifiers.readOnly, className)
        }, React.createElement("span", {
          ref: _this.span,
          className: (0, _reactStyles.css)(_chipCss2["default"].chipText),
          id: randomId
        }, children), !isReadOnly && React.createElement(_ChipButton.ChipButton, {
          onClick: onClick,
          ariaLabel: closeBtnAriaLabel,
          id: "remove_".concat(randomId),
          "aria-labelledby": "remove_".concat(randomId, " ").concat(randomId)
        }, React.createElement(_reactIcons.TimesCircleIcon, {
          "aria-hidden": "true"
        })));
      });

      _this.state = {
        isTooltipVisible: false
      };
      return _this;
    }

    _createClass(Chip, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.setState({
          isTooltipVisible: Boolean(this.span.current && this.span.current.offsetWidth < this.span.current.scrollWidth)
        });
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this;

        var isOverflowChip = this.props.isOverflowChip;
        return React.createElement(_GenerateId2["default"], null, function (randomId) {
          return isOverflowChip ? _this2.renderOverflowChip() : _this2.renderChip(randomId);
        });
      }
    }]);

    return Chip;
  }(React.Component);

  _defineProperty(Chip, "propTypes", {
    children: _propTypes2["default"].node,
    closeBtnAriaLabel: _propTypes2["default"].string,
    className: _propTypes2["default"].string,
    isOverflowChip: _propTypes2["default"].bool,
    isReadOnly: _propTypes2["default"].bool,
    onClick: _propTypes2["default"].func,
    component: _propTypes2["default"].node,
    tooltipPosition: _propTypes2["default"].oneOf(['top', 'bottom', 'left', 'right'])
  });

  _defineProperty(Chip, "defaultProps", {
    closeBtnAriaLabel: 'close',
    className: '',
    isOverflowChip: false,
    isReadOnly: false,
    tooltipPosition: 'top',
    onClick: function onClick() {
      return undefined;
    },
    component: 'div'
  });

  ;
});