"use strict";

(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "../../@patternfly/patternfly/layouts/Bullseye/bullseye.css.js", "@patternfly/react-styles", "../Backdrop/Backdrop", "./ModalBoxBody", "./ModalBoxHeader", "./ModalBoxCloseButton", "./ModalBox", "./ModalBoxFooter", 'focus-trap-react'], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("../../@patternfly/patternfly/layouts/Bullseye/bullseye.css.js"), require("@patternfly/react-styles"), require("../Backdrop/Backdrop"), require("./ModalBoxBody"), require("./ModalBoxHeader"), require("./ModalBoxCloseButton"), require("./ModalBox"), require("./ModalBoxFooter"), require('focus-trap-react'));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.bullseyeCss, global.reactStyles, global.Backdrop, global.ModalBoxBody, global.ModalBoxHeader, global.ModalBoxCloseButton, global.ModalBox, global.ModalBoxFooter, global.focusTrapReact);
    global.undefined = mod.exports;
  }
})(void 0, function (exports, _propTypes, _react, _bullseyeCss, _reactStyles, _Backdrop, _ModalBoxBody, _ModalBoxHeader, _ModalBoxCloseButton, _ModalBox, _ModalBoxFooter, FocusTrap) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ModalContent = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _bullseyeCss2 = _interopRequireDefault(_bullseyeCss);

  var _Backdrop2 = _interopRequireDefault(_Backdrop);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  var ModalContent = exports.ModalContent = function ModalContent(_ref) {
    var children = _ref.children,
        _ref$className = _ref.className,
        className = _ref$className === void 0 ? '' : _ref$className,
        _ref$isOpen = _ref.isOpen,
        isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
        title = _ref.title,
        _ref$hideTitle = _ref.hideTitle,
        hideTitle = _ref$hideTitle === void 0 ? false : _ref$hideTitle,
        _ref$actions = _ref.actions,
        actions = _ref$actions === void 0 ? [] : _ref$actions,
        _ref$onClose = _ref.onClose,
        onClose = _ref$onClose === void 0 ? function () {
      return undefined;
    } : _ref$onClose,
        _ref$isLarge = _ref.isLarge,
        isLarge = _ref$isLarge === void 0 ? false : _ref$isLarge,
        _ref$isSmall = _ref.isSmall,
        isSmall = _ref$isSmall === void 0 ? false : _ref$isSmall,
        _ref$width = _ref.width,
        width = _ref$width === void 0 ? -1 : _ref$width,
        _ref$ariaDescribedByI = _ref.ariaDescribedById,
        ariaDescribedById = _ref$ariaDescribedByI === void 0 ? '' : _ref$ariaDescribedByI,
        _ref$id = _ref.id,
        id = _ref$id === void 0 ? '' : _ref$id,
        props = _objectWithoutProperties(_ref, ["children", "className", "isOpen", "title", "hideTitle", "actions", "onClose", "isLarge", "isSmall", "width", "ariaDescribedById", "id"]);

    var modalBoxHeader = React.createElement(_ModalBoxHeader.ModalBoxHeader, {
      hideTitle: hideTitle
    }, " ", title, " ");
    var modalBoxFooter = actions.length > 0 && React.createElement(_ModalBoxFooter.ModalBoxFooter, null, " ", actions, " ");

    if (!isOpen) {
      return null;
    }

    var boxStyle = width === -1 ? {} : {
      width: width
    };
    return React.createElement(_Backdrop2["default"], null, React.createElement(FocusTrap, {
      focusTrapOptions: {
        clickOutsideDeactivates: true
      },
      className: (0, _reactStyles.css)(_bullseyeCss2["default"].bullseye)
    }, React.createElement(_ModalBox.ModalBox, {
      style: boxStyle,
      className: className,
      isLarge: isLarge,
      isSmall: isSmall,
      title: title,
      id: ariaDescribedById || id
    }, React.createElement(_ModalBoxCloseButton.ModalBoxCloseButton, {
      onClose: onClose
    }), modalBoxHeader, React.createElement(_ModalBoxBody.ModalBoxBody, _extends({}, props, {
      id: id
    }), children), modalBoxFooter)));
  };

  ModalContent.propTypes = {
    children: _propTypes2["default"].node.isRequired,
    className: _propTypes2["default"].string,
    isLarge: _propTypes2["default"].bool,
    isSmall: _propTypes2["default"].bool,
    isOpen: _propTypes2["default"].bool,
    title: _propTypes2["default"].string.isRequired,
    hideTitle: _propTypes2["default"].bool,
    width: _propTypes2["default"].oneOfType([_propTypes2["default"].number, _propTypes2["default"].string]),
    actions: _propTypes2["default"].any,
    onClose: _propTypes2["default"].func,
    ariaDescribedById: _propTypes2["default"].string,
    id: _propTypes2["default"].string.isRequired
  };
});