"use strict";

(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "../../@patternfly/patternfly/layouts/Grid/grid.css.js", "@patternfly/react-styles"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("../../@patternfly/patternfly/layouts/Grid/grid.css.js"), require("@patternfly/react-styles"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.gridCss, global.reactStyles);
    global.undefined = mod.exports;
  }
})(void 0, function (exports, _gridCss, _reactStyles) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.getOffsetModifier = exports.getRowSpanModifier = exports.getGridSpanModifier = exports.getSpanModifier = exports.getSizeSuffix = exports.getOffsetKey = exports.getRowSpanKey = exports.gridSpans = undefined;

  var _gridCss2 = _interopRequireDefault(_gridCss);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  var gridSpans = exports.gridSpans = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];

  var getRowSpanKey = exports.getRowSpanKey = function getRowSpanKey(size) {
    return "".concat(size, "RowSpan");
  };

  var getOffsetKey = exports.getOffsetKey = function getOffsetKey(size) {
    return "".concat(size, "Offset");
  };

  var getSizeSuffix = exports.getSizeSuffix = function getSizeSuffix(size) {
    return size ? "-on-".concat(size) : '';
  };

  var getSpanModifier = exports.getSpanModifier = function getSpanModifier(value, size) {
    return (0, _reactStyles.getModifier)(_gridCss2["default"], "".concat(value, "-col").concat(getSizeSuffix(size)));
  };

  var getGridSpanModifier = exports.getGridSpanModifier = function getGridSpanModifier(value, size) {
    return (0, _reactStyles.getModifier)(_gridCss2["default"], "-all-".concat(value, "-col").concat(getSizeSuffix(size)));
  };

  var getRowSpanModifier = exports.getRowSpanModifier = function getRowSpanModifier(value, size) {
    return (0, _reactStyles.getModifier)(_gridCss2["default"], "".concat(value, "-row").concat(getSizeSuffix(size)));
  };

  var getOffsetModifier = exports.getOffsetModifier = function getOffsetModifier(value, size) {
    return (0, _reactStyles.getModifier)(_gridCss2["default"], "offset-".concat(value, "-col").concat(getSizeSuffix(size)));
  };
});