/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.util.Features;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.global.CacheContainerConfiguration;
import org.infinispan.configuration.global.GlobalJmxConfiguration;
import org.infinispan.configuration.global.GlobalMetricsConfiguration;
import org.infinispan.configuration.global.GlobalSecurityConfiguration;
import org.infinispan.configuration.global.GlobalStateConfiguration;
import org.infinispan.configuration.global.JGroupsConfiguration;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.infinispan.configuration.global.ShutdownConfiguration;
import org.infinispan.configuration.global.SiteConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadsConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public class GlobalConfiguration
implements ConfigurationInfo {
    @Deprecated
    public static final short DEFAULT_MARSHALL_VERSION = Version.getVersionShort();
    private final Map<Class<?>, ?> modules;
    private final SiteConfiguration site;
    private final ClassLoader cl;
    private final CacheContainerConfiguration cacheContainerConfiguration;
    private final Features features;
    private static ElementDefinition<GlobalConfiguration> ELEMENT_DEFINITION = new DefaultElementDefinition("infinispan");
    private List<ConfigurationInfo> subElements;

    GlobalConfiguration(CacheContainerConfiguration cacheContainerConfiguration, List<?> modules, SiteConfiguration site, ClassLoader cl, Features features) {
        this.cacheContainerConfiguration = cacheContainerConfiguration;
        HashMap moduleMap = new HashMap();
        for (Object module : modules) {
            moduleMap.put(module.getClass(), module);
        }
        this.modules = Collections.unmodifiableMap(moduleMap);
        this.site = site;
        this.cl = cl;
        this.features = features;
        JGroupsConfiguration jgroupsConfiguration = cacheContainerConfiguration.transport().jgroups();
        ThreadsConfiguration threads = cacheContainerConfiguration.threads();
        this.subElements = Arrays.asList(jgroupsConfiguration, threads, cacheContainerConfiguration);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    CacheContainerConfiguration cacheContainer() {
        return this.cacheContainerConfiguration;
    }

    public boolean statistics() {
        return this.cacheContainerConfiguration.statistics();
    }

    public ThreadPoolConfiguration expirationThreadPool() {
        return this.cacheContainerConfiguration.expirationThreadPool();
    }

    public ThreadPoolConfiguration listenerThreadPool() {
        return this.cacheContainerConfiguration.listenerThreadPool();
    }

    public ThreadPoolConfiguration persistenceThreadPool() {
        return this.cacheContainerConfiguration.persistenceThreadPool();
    }

    @Deprecated
    public ThreadPoolConfiguration stateTransferThreadPool() {
        return this.cacheContainerConfiguration.stateTransferThreadPool();
    }

    public ThreadPoolConfiguration asyncThreadPool() {
        return this.cacheContainerConfiguration.asyncThreadPool();
    }

    public GlobalMetricsConfiguration metrics() {
        return this.cacheContainerConfiguration.metrics();
    }

    public GlobalJmxConfiguration jmx() {
        return this.cacheContainerConfiguration.jmx();
    }

    @Deprecated
    public GlobalJmxConfiguration globalJmxStatistics() {
        return this.jmx();
    }

    public String cacheManagerName() {
        return this.cacheContainerConfiguration.cacheManagerName();
    }

    public TransportConfiguration transport() {
        return this.cacheContainerConfiguration.transport();
    }

    public GlobalSecurityConfiguration security() {
        return this.cacheContainerConfiguration.security();
    }

    public SerializationConfiguration serialization() {
        return this.cacheContainerConfiguration.serialization();
    }

    public ShutdownConfiguration shutdown() {
        return this.cacheContainerConfiguration.shutdown();
    }

    public GlobalStateConfiguration globalState() {
        return this.cacheContainerConfiguration.globalState();
    }

    public String asyncThreadPoolName() {
        return this.cacheContainer().asyncExecutor();
    }

    public String listenerThreadPoolName() {
        return this.cacheContainer().listenerExecutor();
    }

    public String expirationThreadPoolName() {
        return this.cacheContainer().expirationExecutor();
    }

    public String persistenceThreadPoolName() {
        return this.cacheContainer().persistenceExecutor();
    }

    @Deprecated
    public String stateTransferThreadPoolName() {
        return this.cacheContainer().stateTransferExecutor();
    }

    public <T> T module(Class<T> moduleClass) {
        return (T)this.modules.get(moduleClass);
    }

    public Map<Class<?>, ?> modules() {
        return this.modules;
    }

    public ClassLoader classLoader() {
        return this.cl;
    }

    public SiteConfiguration sites() {
        return this.site;
    }

    public Optional<String> defaultCacheName() {
        return Optional.ofNullable(this.cacheContainerConfiguration.defaultCacheName());
    }

    public Features features() {
        return this.features;
    }

    public boolean isClustered() {
        return this.transport().transport() != null;
    }

    public boolean isZeroCapacityNode() {
        return this.cacheContainerConfiguration.getZeroCapacityNode();
    }

    public String toString() {
        return "GlobalConfiguration{, modules=" + this.modules + ", site=" + this.site + ", cl=" + this.cl + '}';
    }
}

