/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.handlers;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.WSTrustConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.fed.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientFactory;
import org.picketlink.identity.federation.core.wstrust.STSClientPool;
import org.w3c.dom.Element;

public abstract class STSSecurityHandler
implements SOAPHandler<SOAPMessageContext> {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String USERNAME_MSG_CONTEXT_PROPERTY = "org.picketlink.identity.federation.core.wstrust.handlers.username";
    public static final String PASSWORD_MSG_CONTEXT_PROPERTY = "org.picketlink.identity.federation.core.wstrust.handlers.password";
    private String configFile = "sts-client.properties";
    private STSClientConfig.Builder configBuilder;

    public abstract QName getSecurityElementQName();

    public abstract QName getTokenElementQName();

    @PostConstruct
    public void parseSTSConfig() {
        this.configBuilder = new STSClientConfig.Builder(this.configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean handleMessage(SOAPMessageContext messageContext) {
        block12: {
            STSClientPool pool;
            STSClient stsClient;
            block11: {
                if (this.isOutBound(messageContext)) {
                    return true;
                }
                stsClient = null;
                try {
                    Element securityToken = this.extractSecurityToken(messageContext, this.getSecurityElementQName(), this.getTokenElementQName());
                    if (securityToken == null) {
                        this.throwSecurityTokenUnavailable();
                    }
                    this.setUsernameFromMessageContext(messageContext, this.configBuilder);
                    this.setPasswordFromMessageContext(messageContext, this.configBuilder);
                    STSClientConfig stsClientConfig = this.configBuilder.build();
                    stsClient = this.createSTSClient(stsClientConfig);
                    if (stsClient.validateToken(securityToken)) break block11;
                    this.throwFailedAuthentication();
                }
                catch (WSTrustException e) {
                    this.throwInvalidSecurity();
                    break block12;
                }
                catch (ParsingException e2) {
                    this.throwInvalidSecurity();
                    break block12;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    STSClientPool pool2;
                    if (stsClient != null && (pool2 = STSClientFactory.getInstance()) != null) {
                        pool2.returnClient(stsClient);
                    }
                }
            }
            if (stsClient != null && (pool = STSClientFactory.getInstance()) != null) {
                pool.returnClient(stsClient);
            }
        }
        return true;
    }

    private Element extractSecurityToken(SOAPMessageContext messageContext, QName securityQName, QName tokenQName) {
        try {
            if (securityQName == null) {
                throw logger.nullArgumentError("securityQName from subclass");
            }
            if (tokenQName == null) {
                throw logger.nullArgumentError("tokenQName from subclass");
            }
            SOAPHeader soapHeader = messageContext.getMessage().getSOAPHeader();
            Iterator securityHeaders = soapHeader.getChildElements(securityQName);
            while (securityHeaders.hasNext()) {
                Iterator childElements;
                SOAPHeaderElement elem = (SOAPHeaderElement)securityHeaders.next();
                if (!elem.getElementQName().equals(securityQName) || !(childElements = elem.getChildElements(tokenQName)).hasNext()) continue;
                return (Element)childElements.next();
            }
        }
        catch (SOAPException e) {
            this.throwInvalidSecurity();
        }
        return null;
    }

    private void throwSecurityTokenUnavailable() throws SOAPFaultException {
        SOAPFault soapFault = this.createSoapFault("PL00092: Null Value:No security token could be found in the SOAP Header", WSTrustConstants.SECURITY_TOKEN_UNAVAILABLE);
        throw new SOAPFaultException(soapFault);
    }

    private void throwFailedAuthentication() throws SOAPFaultException {
        SOAPFault soapFault = this.createSoapFault("The security token could not be authenticated or authorized", WSTrustConstants.FAILED_AUTHENTICATION);
        throw new SOAPFaultException(soapFault);
    }

    private void throwInvalidSecurity() throws SOAPFaultException {
        SOAPFault soapFault = this.createSoapFault("An error occurred while processing the security header", WSTrustConstants.INVALID_SECURITY);
        throw new SOAPFaultException(soapFault);
    }

    private SOAPFault createSoapFault(String msg, QName qname) {
        try {
            SOAPFactory soapFactory = SOAPFactory.newInstance();
            return soapFactory.createFault(msg, qname);
        }
        catch (SOAPException e) {
            throw new WebServiceException("Exception while trying to create SOAPFault", (Throwable)e);
        }
    }

    private void setUsernameFromMessageContext(SOAPMessageContext context, STSClientConfig.Builder builder) {
        String username = (String)context.get((Object)USERNAME_MSG_CONTEXT_PROPERTY);
        if (username != null) {
            this.configBuilder.username(username);
        }
    }

    private void setPasswordFromMessageContext(SOAPMessageContext context, STSClientConfig.Builder builder) {
        String password = (String)context.get((Object)PASSWORD_MSG_CONTEXT_PROPERTY);
        if (password != null) {
            this.configBuilder.password(password);
        }
    }

    public Set<QName> getHeaders() {
        return Collections.singleton(this.getSecurityElementQName());
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    @Resource(name="STSClientConfig")
    public void setConfigFile(String configFile) {
        if (configFile != null) {
            this.configFile = configFile;
        }
    }

    STSClientConfig.Builder getConfigBuilder() {
        return this.configBuilder;
    }

    STSClient createSTSClient(STSClientConfig config) throws ParsingException {
        STSClientPool pool = STSClientFactory.getInstance();
        if (!pool.configExists(config)) {
            pool.createPool(config);
        }
        return pool.getClient(config);
    }

    private boolean isOutBound(SOAPMessageContext messageContext) {
        return (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
    }
}

