/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import javax.ws.rs.core.Response;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.clientregistration.ClientRegistrationAuth;
import org.keycloak.services.clientregistration.ClientRegistrationContext;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.clientregistration.ClientRegistrationTokenUtils;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyManager;
import org.keycloak.services.clientregistration.policy.RegistrationAuth;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.validation.ValidationMessages;
import org.keycloak.validation.ClientValidationUtil;

public abstract class AbstractClientRegistrationProvider
implements ClientRegistrationProvider {
    protected KeycloakSession session;
    protected EventBuilder event;
    protected ClientRegistrationAuth auth;

    public AbstractClientRegistrationProvider(KeycloakSession session) {
        this.session = session;
    }

    public ClientRepresentation create(ClientRegistrationContext context) {
        ClientRepresentation client = context.getClient();
        this.event.event(EventType.CLIENT_REGISTER);
        RegistrationAuth registrationAuth = this.auth.requireCreate(context);
        ValidationMessages validationMessages = new ValidationMessages();
        if (!context.validateClient(validationMessages)) {
            String errorCode = validationMessages.fieldHasError("redirectUris") ? "invalid_redirect_uri" : "invalid_client_metadata";
            throw new ErrorResponseException(errorCode, validationMessages.getStringMessages(), Response.Status.BAD_REQUEST);
        }
        try {
            RealmModel realm = this.session.getContext().getRealm();
            ClientModel clientModel = ClientManager.createClient(this.session, realm, client, true);
            if (clientModel.isServiceAccountsEnabled()) {
                new ClientManager(new RealmManager(this.session)).enableServiceAccount(clientModel);
            }
            if (Boolean.TRUE.equals(client.getAuthorizationServicesEnabled())) {
                RepresentationToModel.createResourceServer((ClientModel)clientModel, (KeycloakSession)this.session, (boolean)true);
            }
            ClientRegistrationPolicyManager.triggerAfterRegister(context, registrationAuth, clientModel);
            client = ModelToRepresentation.toRepresentation((ClientModel)clientModel, (KeycloakSession)this.session);
            client.setSecret(clientModel.getSecret());
            ClientValidationUtil.validate((KeycloakSession)this.session, (ClientModel)clientModel, (boolean)true, c -> {
                this.session.getTransactionManager().setRollbackOnly();
                throw new ErrorResponseException("invalid_client_metadata", c.getError(), Response.Status.BAD_REQUEST);
            });
            String registrationAccessToken = ClientRegistrationTokenUtils.updateRegistrationAccessToken(this.session, clientModel, registrationAuth);
            client.setRegistrationAccessToken(registrationAccessToken);
            if (this.auth.isInitialAccessToken()) {
                ClientInitialAccessModel initialAccessModel = this.auth.getInitialAccessModel();
                this.session.realms().decreaseRemainingCount(realm, initialAccessModel);
            }
            this.event.client(client.getClientId()).success();
            return client;
        }
        catch (ModelDuplicateException e) {
            throw new ErrorResponseException("invalid_client_metadata", "Client Identifier in use", Response.Status.BAD_REQUEST);
        }
    }

    public ClientRepresentation get(ClientModel client) {
        this.event.event(EventType.CLIENT_INFO);
        this.auth.requireView(client);
        ClientRepresentation rep = ModelToRepresentation.toRepresentation((ClientModel)client, (KeycloakSession)this.session);
        if (client.getSecret() != null) {
            rep.setSecret(client.getSecret());
        }
        if (this.auth.isRegistrationAccessToken()) {
            String registrationAccessToken = ClientRegistrationTokenUtils.updateTokenSignature(this.session, this.auth);
            rep.setRegistrationAccessToken(registrationAccessToken);
        }
        this.event.client(client.getClientId()).success();
        return rep;
    }

    public ClientRepresentation update(String clientId, ClientRegistrationContext context) {
        ClientRepresentation rep = context.getClient();
        this.event.event(EventType.CLIENT_UPDATE).client(clientId);
        ClientModel client = this.session.getContext().getRealm().getClientByClientId(clientId);
        RegistrationAuth registrationAuth = this.auth.requireUpdate(context, client);
        if (!client.getClientId().equals(rep.getClientId())) {
            throw new ErrorResponseException("invalid_client_metadata", "Client Identifier modified", Response.Status.BAD_REQUEST);
        }
        ValidationMessages validationMessages = new ValidationMessages();
        if (!context.validateClient(validationMessages)) {
            String errorCode = validationMessages.fieldHasError("redirectUris") ? "invalid_redirect_uri" : "invalid_client_metadata";
            throw new ErrorResponseException(errorCode, validationMessages.getStringMessages(), Response.Status.BAD_REQUEST);
        }
        RepresentationToModel.updateClient((ClientRepresentation)rep, (ClientModel)client);
        RepresentationToModel.updateClientProtocolMappers((ClientRepresentation)rep, (ClientModel)client);
        ClientValidationUtil.validate((KeycloakSession)this.session, (ClientModel)client, (boolean)false, c -> {
            this.session.getTransactionManager().setRollbackOnly();
            throw new ErrorResponseException("invalid_client_metadata", c.getError(), Response.Status.BAD_REQUEST);
        });
        rep = ModelToRepresentation.toRepresentation((ClientModel)client, (KeycloakSession)this.session);
        if (this.auth.isRegistrationAccessToken()) {
            String registrationAccessToken = ClientRegistrationTokenUtils.updateRegistrationAccessToken(this.session, client, this.auth.getRegistrationAuth());
            rep.setRegistrationAccessToken(registrationAccessToken);
        }
        ClientRegistrationPolicyManager.triggerAfterUpdate(context, registrationAuth, client);
        this.event.client(client.getClientId()).success();
        return rep;
    }

    public void delete(String clientId) {
        this.event.event(EventType.CLIENT_DELETE).client(clientId);
        ClientModel client = this.session.getContext().getRealm().getClientByClientId(clientId);
        this.auth.requireDelete(client);
        if (!new ClientManager(new RealmManager(this.session)).removeClient(this.session.getContext().getRealm(), client)) {
            throw new ForbiddenException();
        }
        this.event.client(client.getClientId()).success();
    }

    @Override
    public void setAuth(ClientRegistrationAuth auth) {
        this.auth = auth;
    }

    @Override
    public ClientRegistrationAuth getAuth() {
        return this.auth;
    }

    @Override
    public void setEvent(EventBuilder event) {
        this.event = event;
    }

    @Override
    public EventBuilder getEvent() {
        return this.event;
    }

    public void close() {
    }
}

