/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.regex.Pattern;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.keycloak.TokenVerifier;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AuthenticationManager;

public class AppAuthManager
extends AuthenticationManager {
    private static final String BEARER = "Bearer";
    private static final Pattern WHITESPACES = Pattern.compile("\\s+");

    @Override
    public AuthenticationManager.AuthResult authenticateIdentityCookie(KeycloakSession session, RealmModel realm) {
        AuthenticationManager.AuthResult authResult = super.authenticateIdentityCookie(session, realm);
        if (authResult == null) {
            return null;
        }
        AppAuthManager.createLoginCookie(session, realm, authResult.getUser(), authResult.getSession(), (UriInfo)session.getContext().getUri(), session.getContext().getConnection());
        if (authResult.getSession().isRememberMe()) {
            AppAuthManager.createRememberMeCookie(realm, authResult.getUser().getUsername(), (UriInfo)session.getContext().getUri(), session.getContext().getConnection());
        }
        return authResult;
    }

    private String extractTokenStringFromAuthHeader(String authHeader) {
        if (authHeader == null) {
            return null;
        }
        String[] split = WHITESPACES.split(authHeader.trim());
        if (split.length != 2) {
            return null;
        }
        String bearerPart = split[0];
        if (!bearerPart.equalsIgnoreCase(BEARER)) {
            return null;
        }
        String tokenString = split[1];
        if (ObjectUtil.isBlank((CharSequence)tokenString)) {
            return null;
        }
        return tokenString;
    }

    public String extractAuthorizationHeaderTokenOrReturnNull(HttpHeaders headers) {
        String authHeader = (String)headers.getRequestHeaders().getFirst((Object)"Authorization");
        return this.extractTokenStringFromAuthHeader(authHeader);
    }

    public String extractAuthorizationHeaderToken(HttpHeaders headers) {
        String authHeader = (String)headers.getRequestHeaders().getFirst((Object)"Authorization");
        if (authHeader == null) {
            return null;
        }
        String tokenString = this.extractTokenStringFromAuthHeader(authHeader);
        if (tokenString == null) {
            throw new NotAuthorizedException((Object)BEARER, new Object[0]);
        }
        return tokenString;
    }

    public AuthenticationManager.AuthResult authenticateBearerToken(KeycloakSession session, RealmModel realm) {
        KeycloakContext ctx = session.getContext();
        return this.authenticateBearerToken(session, realm, (UriInfo)ctx.getUri(), ctx.getConnection(), ctx.getRequestHeaders());
    }

    public AuthenticationManager.AuthResult authenticateBearerToken(KeycloakSession session) {
        return this.authenticateBearerToken(session, session.getContext().getRealm(), (UriInfo)session.getContext().getUri(), session.getContext().getConnection(), session.getContext().getRequestHeaders());
    }

    public AuthenticationManager.AuthResult authenticateBearerToken(KeycloakSession session, RealmModel realm, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        return this.authenticateBearerToken(this.extractAuthorizationHeaderToken(headers), session, realm, uriInfo, connection, headers);
    }

    public AuthenticationManager.AuthResult authenticateBearerToken(String tokenString, KeycloakSession session, RealmModel realm, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        if (tokenString == null) {
            return null;
        }
        AuthenticationManager.AuthResult authResult = AppAuthManager.verifyIdentityToken(session, realm, uriInfo, connection, true, true, false, tokenString, headers, new TokenVerifier.Predicate[0]);
        return authResult;
    }
}

