/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.util.LinkedList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.client.ClientLookupProvider;
import org.keycloak.storage.client.ClientStorageProvider;
import org.keycloak.storage.client.ClientStorageProviderFactory;
import org.keycloak.storage.client.ClientStorageProviderModel;

public class ClientStorageManager
implements ClientProvider {
    private static final Logger logger = Logger.getLogger(ClientStorageManager.class);
    protected KeycloakSession session;

    public static boolean isStorageProviderEnabled(RealmModel realm, String providerId) {
        ClientStorageProviderModel model = ClientStorageManager.getStorageProviderModel(realm, providerId);
        return model.isEnabled();
    }

    public static ClientStorageProviderModel getStorageProviderModel(RealmModel realm, String componentId) {
        ComponentModel model = realm.getComponent(componentId);
        if (model == null) {
            return null;
        }
        return new ClientStorageProviderModel(model);
    }

    public static ClientStorageProvider getStorageProvider(KeycloakSession session, RealmModel realm, String componentId) {
        ComponentModel model = realm.getComponent(componentId);
        if (model == null) {
            return null;
        }
        ClientStorageProviderModel storageModel = new ClientStorageProviderModel(model);
        ClientStorageProviderFactory factory = (ClientStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientStorageProvider.class, model.getProviderId());
        if (factory == null) {
            throw new ModelException("Could not find ClientStorageProviderFactory for: " + model.getProviderId());
        }
        return ClientStorageManager.getStorageProviderInstance(session, storageModel, factory);
    }

    public static List<ClientStorageProviderModel> getStorageProviders(RealmModel realm) {
        return realm.getClientStorageProviders();
    }

    public static ClientStorageProvider getStorageProviderInstance(KeycloakSession session, ClientStorageProviderModel model, ClientStorageProviderFactory factory) {
        ClientStorageProvider instance = (ClientStorageProvider)session.getAttribute(model.getId());
        if (instance != null) {
            return instance;
        }
        instance = factory.create(session, (ComponentModel)model);
        if (instance == null) {
            throw new IllegalStateException("ClientStorageProvideFactory (of type " + factory.getClass().getName() + ") produced a null instance");
        }
        session.enlistForClose((Provider)instance);
        session.setAttribute(model.getId(), (Object)instance);
        return instance;
    }

    public static <T> List<T> getStorageProviders(KeycloakSession session, RealmModel realm, Class<T> type) {
        LinkedList<T> list = new LinkedList<T>();
        for (ClientStorageProviderModel model : ClientStorageManager.getStorageProviders(realm)) {
            ClientStorageProviderFactory factory = (ClientStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientStorageProvider.class, model.getProviderId());
            if (factory == null) {
                logger.warnv("Configured ClientStorageProvider {0} of provider id {1} does not exist in realm {2}", (Object)model.getName(), (Object)model.getProviderId(), (Object)realm.getName());
                continue;
            }
            if (!Types.supports(type, (Object)factory, ClientStorageProviderFactory.class)) continue;
            list.add(type.cast(ClientStorageManager.getStorageProviderInstance(session, model, factory)));
        }
        return list;
    }

    public static <T> List<T> getEnabledStorageProviders(KeycloakSession session, RealmModel realm, Class<T> type) {
        LinkedList<T> list = new LinkedList<T>();
        for (ClientStorageProviderModel model : ClientStorageManager.getStorageProviders(realm)) {
            if (!model.isEnabled()) continue;
            ClientStorageProviderFactory factory = (ClientStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientStorageProvider.class, model.getProviderId());
            if (factory == null) {
                logger.warnv("Configured ClientStorageProvider {0} of provider id {1} does not exist in realm {2}", (Object)model.getName(), (Object)model.getProviderId(), (Object)realm.getName());
                continue;
            }
            if (!Types.supports(type, (Object)factory, ClientStorageProviderFactory.class)) continue;
            list.add(type.cast(ClientStorageManager.getStorageProviderInstance(session, model, factory)));
        }
        return list;
    }

    public ClientStorageManager(KeycloakSession session) {
        this.session = session;
    }

    public ClientModel getClientById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        if (storageId.getProviderId() == null) {
            return this.session.clientLocalStorage().getClientById(realm, id);
        }
        ClientStorageProvider provider = ClientStorageManager.getStorageProvider(this.session, realm, storageId.getProviderId());
        if (provider == null) {
            return null;
        }
        if (!ClientStorageManager.isStorageProviderEnabled(realm, storageId.getProviderId())) {
            return null;
        }
        return provider.getClientById(realm, id);
    }

    public ClientModel getClientByClientId(RealmModel realm, String clientId) {
        ClientModel client = this.session.clientLocalStorage().getClientByClientId(realm, clientId);
        if (client != null) {
            return client;
        }
        for (ClientLookupProvider provider : ClientStorageManager.getEnabledStorageProviders(this.session, realm, ClientLookupProvider.class)) {
            client = provider.getClientByClientId(realm, clientId);
            if (client == null) continue;
            return client;
        }
        return null;
    }

    public List<ClientModel> searchClientsByClientId(RealmModel realm, String clientId, Integer firstResult, Integer maxResults) {
        List clients = this.session.clientLocalStorage().searchClientsByClientId(realm, clientId, firstResult, maxResults);
        if (clients != null) {
            return clients;
        }
        for (ClientLookupProvider provider : ClientStorageManager.getEnabledStorageProviders(this.session, realm, ClientLookupProvider.class)) {
            clients = provider.searchClientsByClientId(realm, clientId, firstResult, maxResults);
            if (clients == null) continue;
            return clients;
        }
        return null;
    }

    public ClientModel addClient(RealmModel realm, String clientId) {
        return this.session.clientLocalStorage().addClient(realm, clientId);
    }

    public ClientModel addClient(RealmModel realm, String id, String clientId) {
        return this.session.clientLocalStorage().addClient(realm, id, clientId);
    }

    public List<ClientModel> getClients(RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.session.clientLocalStorage().getClients(realm, firstResult, maxResults);
    }

    public List<ClientModel> getClients(RealmModel realm) {
        return this.session.clientLocalStorage().getClients(realm);
    }

    public long getClientsCount(RealmModel realm) {
        return this.session.clientLocalStorage().getClientsCount(realm);
    }

    public List<ClientModel> getAlwaysDisplayInConsoleClients(RealmModel realm) {
        return this.session.clientLocalStorage().getAlwaysDisplayInConsoleClients(realm);
    }

    public void removeClients(RealmModel realm) {
        this.session.clientLocalStorage().removeClients(realm);
    }

    public void close() {
    }

    public boolean removeClient(RealmModel realm, String id) {
        if (!StorageId.isLocalStorage((String)id)) {
            throw new RuntimeException("Federated clients do not support this operation");
        }
        return this.session.clientLocalStorage().removeClient(realm, id);
    }
}

