/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.keycloak.models.jpa.entities.UserConsentEntity;

@NamedQueries(value={@NamedQuery(name="deleteUserConsentClientScopesByRealm", query="delete from UserConsentClientScopeEntity grantedScope where grantedScope.userConsent IN (select consent from UserConsentEntity consent where consent.user IN (select user from UserEntity user where user.realmId = :realmId))"), @NamedQuery(name="deleteUserConsentClientScopesByRealmAndLink", query="delete from UserConsentClientScopeEntity grantedScope where grantedScope.userConsent IN (select consent from UserConsentEntity consent where consent.user IN (select u from UserEntity u where u.realmId=:realmId and u.federationLink=:link))"), @NamedQuery(name="deleteUserConsentClientScopesByUser", query="delete from UserConsentClientScopeEntity grantedScope where grantedScope.userConsent IN (select consent from UserConsentEntity consent where consent.user = :user)"), @NamedQuery(name="deleteUserConsentClientScopesByClientScope", query="delete from UserConsentClientScopeEntity grantedScope where grantedScope.scopeId = :scopeId"), @NamedQuery(name="deleteUserConsentClientScopesByClient", query="delete from UserConsentClientScopeEntity grantedScope where grantedScope.userConsent IN (select consent from UserConsentEntity consent where consent.clientId = :clientId)"), @NamedQuery(name="deleteUserConsentClientScopesByExternalClient", query="delete from UserConsentClientScopeEntity grantedScope where grantedScope.userConsent IN (select consent from UserConsentEntity consent where consent.clientStorageProvider = :clientStorageProvider and consent.externalClientId = :externalClientId)"), @NamedQuery(name="deleteUserConsentClientScopesByClientStorageProvider", query="delete from UserConsentClientScopeEntity grantedScope where grantedScope.userConsent IN (select consent from UserConsentEntity consent where consent.clientStorageProvider = :clientStorageProvider)")})
@Entity
@Table(name="USER_CONSENT_CLIENT_SCOPE")
@IdClass(value=Key.class)
public class UserConsentClientScopeEntity {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USER_CONSENT_ID")
    protected UserConsentEntity userConsent;
    @Id
    @Column(name="SCOPE_ID")
    protected String scopeId;

    public UserConsentEntity getUserConsent() {
        return this.userConsent;
    }

    public void setUserConsent(UserConsentEntity userConsent) {
        this.userConsent = userConsent;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof UserConsentClientScopeEntity)) {
            return false;
        }
        UserConsentClientScopeEntity that = (UserConsentClientScopeEntity)o;
        Key myKey = new Key(this.userConsent, this.scopeId);
        Key hisKey = new Key(that.userConsent, that.scopeId);
        return myKey.equals(hisKey);
    }

    public int hashCode() {
        Key myKey = new Key(this.userConsent, this.scopeId);
        return myKey.hashCode();
    }

    public static class Key
    implements Serializable {
        protected UserConsentEntity userConsent;
        protected String scopeId;

        public Key() {
        }

        public Key(UserConsentEntity userConsent, String scopeId) {
            this.userConsent = userConsent;
            this.scopeId = scopeId;
        }

        public UserConsentEntity getUserConsent() {
            return this.userConsent;
        }

        public String getScopeId() {
            return this.scopeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.userConsent != null ? !this.userConsent.getId().equals(key.userConsent != null ? key.userConsent.getId() : null) : key.userConsent != null) {
                return false;
            }
            return !(this.scopeId != null ? !this.scopeId.equals(key.scopeId) : key.scopeId != null);
        }

        public int hashCode() {
            int result = this.userConsent != null ? this.userConsent.getId().hashCode() : 0;
            result = 31 * result + (this.scopeId != null ? this.scopeId.hashCode() : 0);
            return result;
        }
    }
}

