/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolConfiguration;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolFactory;
import org.jgroups.util.ShutdownRejectedExecutionHandler;

public class QueuelessThreadPoolFactory
implements ThreadPoolConfiguration,
ThreadPoolFactory {
    private volatile int minThreads = 0;
    private volatile int maxThreads = Integer.MAX_VALUE;
    private volatile long keepAliveTime = 0L;

    public QueuelessThreadPoolFactory setMinThreads(int minThreads) {
        this.minThreads = minThreads;
        return this;
    }

    public QueuelessThreadPoolFactory setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public QueuelessThreadPoolFactory setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        return this;
    }

    @Override
    public int getMinThreads() {
        return this.minThreads;
    }

    @Override
    public int getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    @Override
    public Executor apply(ThreadFactory threadFactory) {
        ShutdownRejectedExecutionHandler handler = new ShutdownRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        return new ThreadPoolExecutor(this.getMinThreads(), this.getMaxThreads(), this.getKeepAliveTime(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), threadFactory, (RejectedExecutionHandler)handler);
    }
}

