/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.time.Duration;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.PrimaryOwnerLocator;
import org.wildfly.clustering.ee.infinispan.scheduler.PrimaryOwnerScheduler;
import org.wildfly.clustering.ee.infinispan.tx.InfinispanBatcher;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.distribution.CacheLocality;
import org.wildfly.clustering.infinispan.spi.distribution.ConsistentHashLocality;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.infinispan.spi.distribution.SimpleLocality;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.spi.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.MarshalledValueSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.AffinityIdentifierFactory;
import org.wildfly.clustering.web.infinispan.session.ExpiredSessionRemover;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManager;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKeyFilter;
import org.wildfly.clustering.web.infinispan.session.SessionExpirationScheduler;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionAttributesFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SpecificationProvider;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class InfinispanSessionManagerFactory<S, SC, AL, BL, MC, LC>
implements SessionManagerFactory<SC, LC, TransactionBatch> {
    final Batcher<TransactionBatch> batcher;
    final Registrar<SessionExpirationListener> expirationRegistrar;
    final CacheProperties properties;
    final Cache<Key<String>, ?> cache;
    final Scheduler<String, ImmutableSessionMetaData> primaryOwnerScheduler;
    final SpecificationProvider<S, SC, AL, BL> provider;
    private final KeyAffinityServiceFactory affinityFactory;
    private final SessionFactory<SC, CompositeSessionMetaDataEntry<LC>, ?, LC> factory;
    private final org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<String, ImmutableSessionMetaData> expirationScheduler;
    private final SessionCreationMetaDataKeyFilter filter = new SessionCreationMetaDataKeyFilter();
    private final ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory(InfinispanSessionManager.class));
    private final AtomicReference<Future<?>> rehashFuture = new AtomicReference();
    private final AtomicInteger rehashTopology = new AtomicInteger();

    public InfinispanSessionManagerFactory(InfinispanSessionManagerFactoryConfiguration<S, SC, AL, BL, MC, LC> config) {
        this.affinityFactory = config.getKeyAffinityServiceFactory();
        this.cache = config.getCache();
        this.batcher = new InfinispanBatcher(this.cache);
        this.properties = config.getCacheProperties();
        this.provider = config.getSpecificationProvider();
        InfinispanSessionMetaDataFactory metaDataFactory = new InfinispanSessionMetaDataFactory(config);
        this.factory = new CompositeSessionFactory(metaDataFactory, this.createSessionAttributesFactory(config), config.getLocalContextFactory());
        ExpiredSessionRemover remover = new ExpiredSessionRemover(this.factory);
        this.expirationRegistrar = remover;
        this.expirationScheduler = new SessionExpirationScheduler(this.batcher, this.factory.getMetaDataFactory(), remover, Duration.ofMillis(this.cache.getCacheConfiguration().transaction().cacheStopTimeout()));
        CommandDispatcherFactory dispatcherFactory = config.getCommandDispatcherFactory();
        PrimaryOwnerLocator primaryOwnerLocator = new PrimaryOwnerLocator(this.cache, config.getMemberFactory(), dispatcherFactory.getGroup());
        this.primaryOwnerScheduler = new PrimaryOwnerScheduler(dispatcherFactory, this.cache.getName(), this.expirationScheduler, (Function)primaryOwnerLocator, Key::new);
        this.cache.addListener((Object)this);
        new ScheduleExpirationTask(this.cache, (Predicate<Object>)((Object)this.filter), this.expirationScheduler, (Locality)new SimpleLocality(false), (Locality)new CacheLocality(this.cache)).run();
    }

    public SessionManager<LC, TransactionBatch> createSessionManager(final SessionManagerConfiguration<SC> configuration) {
        final AffinityIdentifierFactory<String> factory = new AffinityIdentifierFactory<String>(configuration.getIdentifierFactory(), this.cache, this.affinityFactory);
        InfinispanSessionManagerConfiguration config = new InfinispanSessionManagerConfiguration<S, SC, AL, BL>(){

            @Override
            public SessionExpirationListener getExpirationListener() {
                return configuration.getExpirationListener();
            }

            @Override
            public SC getServletContext() {
                return configuration.getServletContext();
            }

            @Override
            public Cache<Key<String>, ?> getCache() {
                return InfinispanSessionManagerFactory.this.cache;
            }

            @Override
            public CacheProperties getProperties() {
                return InfinispanSessionManagerFactory.this.properties;
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return factory;
            }

            @Override
            public Batcher<TransactionBatch> getBatcher() {
                return InfinispanSessionManagerFactory.this.batcher;
            }

            @Override
            public Registrar<SessionExpirationListener> getExpirationRegistar() {
                return InfinispanSessionManagerFactory.this.expirationRegistrar;
            }

            @Override
            public Recordable<ImmutableSession> getInactiveSessionRecorder() {
                return configuration.getInactiveSessionRecorder();
            }

            @Override
            public Scheduler<String, ImmutableSessionMetaData> getExpirationScheduler() {
                return InfinispanSessionManagerFactory.this.primaryOwnerScheduler;
            }

            @Override
            public SpecificationProvider<S, SC, AL, BL> getSpecificationProvider() {
                return InfinispanSessionManagerFactory.this.provider;
            }
        };
        return new InfinispanSessionManager(this.factory, config);
    }

    private SessionAttributesFactory<SC, ?> createSessionAttributesFactory(InfinispanSessionManagerFactoryConfiguration<S, SC, AL, BL, MC, LC> configuration) {
        switch (configuration.getAttributePersistenceStrategy()) {
            case FINE: {
                return new FineSessionAttributesFactory(new InfinispanMarshalledValueSessionAttributesFactoryConfiguration(configuration));
            }
            case COARSE: {
                return new CoarseSessionAttributesFactory(new InfinispanMarshalledValueSessionAttributesFactoryConfiguration(configuration));
            }
        }
        throw new IllegalStateException();
    }

    public void close() {
        this.cache.removeListener((Object)this);
        WildFlySecurityManager.doUnchecked((Object)this.executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
        try {
            this.executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.primaryOwnerScheduler.close();
    }

    @DataRehashed
    public void dataRehashed(DataRehashedEvent<Key<String>, ?> event) {
        Cache cache = event.getCache();
        ConsistentHashLocality newLocality = new ConsistentHashLocality(cache, event.getConsistentHashAtEnd());
        try {
            if (event.isPre()) {
                this.rehashTopology.set(event.getNewTopologyId());
                Future future = this.rehashFuture.getAndSet(null);
                if (future != null) {
                    future.cancel(true);
                }
                this.executor.submit(new CancelExpirationTask(this.expirationScheduler, (Locality)newLocality));
            } else {
                this.rehashTopology.compareAndSet(event.getNewTopologyId(), 0);
                ConsistentHashLocality oldLocality = new ConsistentHashLocality(cache, event.getConsistentHashAtStart());
                this.rehashFuture.compareAndSet(null, this.executor.submit(new ScheduleExpirationTask(cache, (Predicate<Object>)((Object)this.filter), this.expirationScheduler, (Locality)oldLocality, (Locality)newLocality)));
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<Key<String>, ?> event) {
        if (!event.isPre() && this.rehashTopology.get() != event.getNewTopologyId()) {
            Future future = this.rehashFuture.getAndSet(null);
            if (future != null) {
                future.cancel(true);
            }
            Cache cache = event.getCache();
            ConsistentHashLocality oldLocality = new ConsistentHashLocality(cache, event.getReadConsistentHashAtStart());
            ConsistentHashLocality newLocality = new ConsistentHashLocality(cache, event.getWriteConsistentHashAtEnd());
            try {
                this.rehashFuture.compareAndSet(null, this.executor.submit(new ScheduleExpirationTask(cache, (Predicate<Object>)((Object)this.filter), this.expirationScheduler, (Locality)oldLocality, (Locality)newLocality)));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private static class InfinispanMarshalledValueSessionAttributesFactoryConfiguration<S, SC, AL, BL, V, MC, LC>
    extends MarshalledValueSessionAttributesFactoryConfiguration<S, SC, AL, V, MC, LC>
    implements InfinispanSessionAttributesFactoryConfiguration<S, SC, AL, V, MarshalledValue<V, MC>> {
        private final InfinispanSessionManagerFactoryConfiguration<S, SC, AL, BL, MC, LC> configuration;

        InfinispanMarshalledValueSessionAttributesFactoryConfiguration(InfinispanSessionManagerFactoryConfiguration<S, SC, AL, BL, MC, LC> configuration) {
            super(configuration);
            this.configuration = configuration;
        }

        public <CK, CV> Cache<CK, CV> getCache() {
            return this.configuration.getCache();
        }
    }

    private static class ScheduleExpirationTask
    implements Runnable {
        private final Cache<Key<String>, ?> cache;
        private final Predicate<Object> filter;
        private final org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<String, ImmutableSessionMetaData> scheduler;
        private final Locality oldLocality;
        private final Locality newLocality;

        ScheduleExpirationTask(Cache<Key<String>, ?> cache, Predicate<Object> filter, org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<String, ImmutableSessionMetaData> scheduler, Locality oldLocality, Locality newLocality) {
            this.cache = cache;
            this.filter = filter;
            this.scheduler = scheduler;
            this.oldLocality = oldLocality;
            this.newLocality = newLocality;
        }

        @Override
        public void run() {
            try (CacheStream stream = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD}).keySet().stream().filter(this.filter);){
                Iterator keys = stream.iterator();
                while (keys.hasNext()) {
                    if (Thread.currentThread().isInterrupted()) {
                        break;
                    }
                    Key key = (Key)keys.next();
                    if (this.oldLocality.isLocal((Object)key) || !this.newLocality.isLocal((Object)key)) continue;
                    this.scheduler.schedule(key.getValue());
                }
            }
        }
    }

    private static class CancelExpirationTask
    implements Runnable {
        private final org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<String, ImmutableSessionMetaData> scheduler;
        private final Locality locality;

        CancelExpirationTask(org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<String, ImmutableSessionMetaData> scheduler, Locality locality) {
            this.scheduler = scheduler;
            this.locality = locality;
        }

        @Override
        public void run() {
            this.scheduler.cancel(this.locality);
        }
    }
}

