/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines.factory;

import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.client.jaxrs.i18n.LogMessages;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;

public class ApacheHttpClient4EngineFactory {
    private ApacheHttpClient4EngineFactory() {
    }

    public static ClientHttpEngine createWithDefaultProxy(HttpHost defaultProxy) {
        if (ApacheHttpClient4EngineFactory.isConfigurableAvailable()) {
            ApacheHttpClient43Engine engine = new ApacheHttpClient43Engine(defaultProxy);
            if (ApacheHttpClient4EngineFactory.isUsingOldStyleConfiguration(engine.getHttpClient())) {
                LogMessages.LOGGER.warn(Messages.MESSAGES.pleaseConsiderUnpdating());
                engine.close();
                return new ApacheHttpClient4Engine(defaultProxy);
            }
            return engine;
        }
        return new ApacheHttpClient4Engine(defaultProxy);
    }

    public static ClientHttpEngine create() {
        return ApacheHttpClient4EngineFactory.createWithDefaultProxy(null);
    }

    public static ClientHttpEngine create(HttpClient httpClient) {
        if (ApacheHttpClient4EngineFactory.isUsingOldStyleConfiguration(httpClient)) {
            return new ApacheHttpClient4Engine(httpClient);
        }
        return new ApacheHttpClient43Engine(httpClient);
    }

    public static ClientHttpEngine create(HttpClient httpClient, boolean closeHttpClient) {
        if (ApacheHttpClient4EngineFactory.isUsingOldStyleConfiguration(httpClient)) {
            return new ApacheHttpClient4Engine(httpClient, closeHttpClient);
        }
        return new ApacheHttpClient43Engine(httpClient, closeHttpClient);
    }

    public static ClientHttpEngine create(HttpClient httpClient, HttpContext httpContext) {
        if (ApacheHttpClient4EngineFactory.isUsingOldStyleConfiguration(httpClient)) {
            return new ApacheHttpClient4Engine(httpClient, httpContext);
        }
        return new ApacheHttpClient43Engine(httpClient, httpContext);
    }

    private static boolean isUsingOldStyleConfiguration(HttpClient client) {
        boolean isOld = true;
        try {
            client.getParams();
            LogMessages.LOGGER.warn(Messages.MESSAGES.pleaseConsiderUnpdating());
        }
        catch (UnsupportedOperationException e) {
            isOld = false;
        }
        return isOld;
    }

    private static boolean isConfigurableAvailable() {
        try {
            Class.forName("org.apache.http.client.methods.Configurable");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

