/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.js;

import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.js.JSPolicyProviderFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.ScriptModel;
import org.keycloak.representations.idm.authorization.JSPolicyRepresentation;
import org.keycloak.representations.provider.ScriptProviderMetadata;
import org.keycloak.scripting.ScriptingProvider;

public final class DeployedScriptPolicyFactory
extends JSPolicyProviderFactory {
    private final ScriptProviderMetadata metadata;

    public DeployedScriptPolicyFactory(ScriptProviderMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public String getId() {
        return this.metadata.getId();
    }

    @Override
    public String getName() {
        return this.metadata.getName();
    }

    @Override
    protected boolean isDeployed() {
        return true;
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public JSPolicyRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        JSPolicyRepresentation representation = new JSPolicyRepresentation();
        representation.setId(policy.getId());
        representation.setName(policy.getName());
        representation.setDescription(this.metadata.getDescription());
        representation.setType(this.getId());
        representation.setCode(this.metadata.getCode());
        return representation;
    }

    @Override
    protected ScriptModel getScriptModel(Policy policy, RealmModel realm, ScriptingProvider scripting) {
        return scripting.createScript(realm.getId(), "text/javascript", this.metadata.getName(), this.metadata.getCode(), this.metadata.getDescription());
    }

    @Override
    public void onCreate(Policy policy, JSPolicyRepresentation representation, AuthorizationProvider authorization) {
        representation.setDescription(this.metadata.getDescription());
        policy.setDescription(this.metadata.getDescription());
        super.onCreate(policy, representation, authorization);
    }
}

