/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

public class HexUtil {
    private static final String HEX_CHARS = "0123456789ABCDEF";
    private static final char[] HEX_CHAR_ARRAY = "0123456789ABCDEF".toCharArray();

    private HexUtil() {
    }

    public static byte[] decode(String source) {
        int sourceLength = (source = source.toUpperCase()).length();
        if (sourceLength % 2 != 0) {
            throw new IllegalArgumentException("source length must be even-length.");
        }
        byte[] bytes = new byte[sourceLength / 2];
        char[] sourceChars = source.toCharArray();
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)((HEX_CHARS.indexOf(sourceChars[i * 2]) << 4) + HEX_CHARS.indexOf(sourceChars[i * 2 + 1]));
        }
        return bytes;
    }

    public static String encodeToString(byte[] source) {
        StringBuilder stringBuilder = new StringBuilder(source.length * 2);
        for (byte item : source) {
            stringBuilder.append(HEX_CHAR_ARRAY[item >> 4 & 0xF]);
            stringBuilder.append(HEX_CHAR_ARRAY[item & 0xF]);
        }
        return stringBuilder.toString();
    }
}

