/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.specimpl.ResponseBuilderImpl;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.ProtocolMapperUtils;
import org.keycloak.protocol.docker.DockerEndpoint;
import org.keycloak.protocol.docker.DockerKeyIdentifier;
import org.keycloak.protocol.docker.mapper.DockerAuthV2AttributeMapper;
import org.keycloak.representations.docker.DockerResponse;
import org.keycloak.representations.docker.DockerResponseToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.sessions.AuthenticationSessionModel;

public class DockerAuthV2Protocol
implements LoginProtocol {
    protected static final Logger logger = Logger.getLogger(DockerEndpoint.class);
    public static final String LOGIN_PROTOCOL = "docker-v2";
    public static final String ACCOUNT_PARAM = "account";
    public static final String SERVICE_PARAM = "service";
    public static final String SCOPE_PARAM = "scope";
    public static final String ISSUER = "docker.iss";
    public static final String ISO_8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private KeycloakSession session;
    private RealmModel realm;
    private UriInfo uriInfo;
    private HttpHeaders headers;
    private EventBuilder event;

    public DockerAuthV2Protocol() {
    }

    public DockerAuthV2Protocol(KeycloakSession session, RealmModel realm, UriInfo uriInfo, HttpHeaders headers, EventBuilder event) {
        this.session = session;
        this.realm = realm;
        this.uriInfo = uriInfo;
        this.headers = headers;
        this.event = event;
    }

    public LoginProtocol setSession(KeycloakSession session) {
        this.session = session;
        return this;
    }

    public LoginProtocol setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public LoginProtocol setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public LoginProtocol setHttpHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public LoginProtocol setEventBuilder(EventBuilder event) {
        this.event = event;
        return this;
    }

    public Response authenticated(AuthenticationSessionModel authSession, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        AuthenticatedClientSessionModel clientSession = clientSessionCtx.getClientSession();
        ClientModel client = clientSession.getClient();
        DockerResponseToken responseToken = new DockerResponseToken().id(KeycloakModelUtils.generateId()).type("Bearer").issuer(authSession.getClientNote(ISSUER)).subject(userSession.getUser().getUsername()).issuedNow().audience(new String[]{client.getClientId()}).issuedFor(client.getClientId());
        int accessTokenLifespan = this.realm.getAccessTokenLifespan();
        responseToken.notBefore(responseToken.getIssuedAt()).expiration(responseToken.getIssuedAt() + accessTokenLifespan);
        for (Map.Entry<ProtocolMapperModel, ProtocolMapper> entry : ProtocolMapperUtils.getSortedProtocolMappers(this.session, clientSessionCtx)) {
            DockerAuthV2AttributeMapper dockerAttributeMapper;
            ProtocolMapperModel mapping = entry.getKey();
            ProtocolMapper mapper = entry.getValue();
            if (!(mapper instanceof DockerAuthV2AttributeMapper) || !(dockerAttributeMapper = (DockerAuthV2AttributeMapper)mapper).appliesTo(responseToken)) continue;
            responseToken = dockerAttributeMapper.transformDockerResponseToken(responseToken, mapping, this.session, userSession, clientSession);
        }
        try {
            if (this.event.getEvent() != null && EventType.LOGIN.equals((Object)this.event.getEvent().getType())) {
                KeyManager.ActiveRsaKey activeKey = this.session.keys().getActiveRsaKey(this.realm);
                String encodedToken = new JWSBuilder().kid(new DockerKeyIdentifier(activeKey.getPublicKey()).toString()).type("JWT").jsonContent((Object)responseToken).rsa256(activeKey.getPrivateKey());
                String expiresInIso8601String = new SimpleDateFormat(ISO_8601_DATE_FORMAT).format(new Date((long)responseToken.getIssuedAt() * 1000L));
                DockerResponse responseEntity = new DockerResponse().setToken(encodedToken).setExpires_in(Integer.valueOf(accessTokenLifespan)).setIssued_at(expiresInIso8601String);
                return new ResponseBuilderImpl().status(Response.Status.OK).header("Content-Type", (Object)"application/json").entity((Object)responseEntity).build();
            }
            logger.errorv("Unable to handle request for event type {0}.  Currently only LOGIN event types are supported by docker protocol.", (Object)(this.event.getEvent() == null ? "null" : this.event.getEvent().getType()));
            throw new ErrorResponseException("invalid_request", "Event type not supported", Response.Status.BAD_REQUEST);
        }
        catch (InstantiationException e) {
            logger.errorv("Error attempting to create Key ID for Docker JOSE header: ", (Object)e.getMessage());
            throw new ErrorResponseException("token_error", "Unable to construct JOSE header for JWT", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public Response sendError(AuthenticationSessionModel clientSession, LoginProtocol.Error error) {
        return new ResponseBuilderImpl().status(Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    public void backchannelLogout(UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        this.errorResponse(userSession, "backchannelLogout");
    }

    public Response frontchannelLogout(UserSessionModel userSession, AuthenticatedClientSessionModel clientSession) {
        return this.errorResponse(userSession, "frontchannelLogout");
    }

    public Response finishLogout(UserSessionModel userSession) {
        return this.errorResponse(userSession, "finishLogout");
    }

    public boolean requireReauthentication(UserSessionModel userSession, AuthenticationSessionModel clientSession) {
        return true;
    }

    private Response errorResponse(UserSessionModel userSession, String methodName) {
        logger.errorv("User {0} attempted to invoke unsupported method {1} on docker protocol.", (Object)userSession.getUser().getUsername(), (Object)methodName);
        throw new ErrorResponseException("invalid_request", String.format("Attempted to invoke unsupported docker method %s", methodName), Response.Status.BAD_REQUEST);
    }

    public void close() {
    }
}

